﻿---
title: Create custom images
description: You can create your own custom application images (Elasticsearch, Kibana, APM Server, Beats, Elastic Agent, Elastic Maps Server, and Logstash) instead...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/create-custom-images
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Create custom images
You can create your own custom application images (Elasticsearch, Kibana, APM Server, Beats, Elastic Agent, Elastic Maps Server, and Logstash) instead of using the base images provided by Elastic. You might want to do this to have a canonical image with all the necessary plugins pre-loaded rather than [installing them through an init container](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/init-containers-for-plugin-downloads) each time a Pod starts.  You must use the official image as the base for custom images. For example, if you want to create an Elasticsearch 9.3.0 image with the [ICU Analysis Plugin](https://www.elastic.co/docs/reference/elasticsearch/plugins/analysis-icu), you can do the following:
1. Create a `Dockerfile` containing:
   ```sh
   FROM docker.elastic.co/elasticsearch/elasticsearch:9.3.0
   RUN bin/elasticsearch-plugin install --batch analysis-icu
   ```
2. Build the image with:
   ```sh
   docker build --tag elasticsearch-icu:9.3.0
   ```

There are various hosting options for your images. If you use Google Kubernetes Engine, it is automatically configured to use the Google Container Registry. Check [Using Container Registry with Google Cloud](https://cloud.google.com/container-registry/docs/using-with-google-cloud-platform#google-kubernetes-engine) for more information. To use the image, you can then [push to the registry](https://cloud.google.com/container-registry/docs/pushing-and-pulling#pushing_an_image_to_a_registry) with:
```sh
docker tag elasticsearch-icu:9.3.0 gcr.io/$PROJECT-ID/elasticsearch-icu:9.3.0
docker push gcr.io/$PROJECT-ID/elasticsearch-icu:9.3.0
```

Configure your Elasticsearch specification to use the newly pushed image, for example:
```yaml
spec:
  version: 9.3.0
  image: gcr.io/$PROJECT-ID/elasticsearch-icu:9.3.0
```

<note>
  Providing the correct version is always required as ECK reasons about APIs and capabilities available to it based on the version field.
</note>

The steps are similar for [Azure Kubernetes Service](https://docs.microsoft.com/en-us/azure/aks/tutorial-kubernetes-prepare-acr) and [AWS Elastic Container Registry](https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-basics.html#use-ecr).
If your custom images follow the naming convention adopted by the official images, and you only want to use your custom images, you can also simply [override the container registry](/docs/deploy-manage/deploy/cloud-on-k8s/air-gapped-install#k8s-container-registry-override).
For more information, check the following references:
- [Elasticsearch documentation on Using custom Docker images](/docs/deploy-manage/deploy/self-managed/install-elasticsearch-docker-configure#_c_customized_image)
- [Google Container Registry](https://cloud.google.com/container-registry/docs/how-to)
- [Azure Container Registry](https://docs.microsoft.com/en-us/azure/container-registry/)
- [Amazon Elastic Container Registry](https://docs.aws.amazon.com/AmazonECR/latest/userguide/what-is-ecr.html)
- [OpenShift Container Platform registry](https://docs.openshift.com/container-platform/4.12/registry/index.html)