﻿---
title: Connect to the APM Server
description: This section covers the following topics: APM Server service, APM Server secret token, APM Server API keys. The APM Server is exposed with a Service...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/connect-to-apm-server
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Connect to the APM Server
This section covers the following topics:
- [APM Server service](#k8s-apm-service)
- [APM Server secret token](#k8s-apm-secret-token)
- [APM Server API keys](#k8s-apm-api-keys)


## APM Server service

The APM Server is exposed with a Service. For information on accessing it, check [How to access Elastic Stack services](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/accessing-services).
To retrieve the list of all the APM Services, use the following command:
```sh
kubectl get service --selector='common.k8s.elastic.co/type=apm-server'
```

```sh
NAME                             TYPE        CLUSTER-IP   EXTERNAL-IP   PORT(S)    AGE
apm-server-quickstart-apm-http   ClusterIP   10.0.1.252   <none>        8200/TCP   154m
```


## APM Server secret token

The operator generates an authorization token that agents must send to authenticate themselves to the APM Server.
This token is stored in a secret named `{{APM-server-name}}-apm-token` and can be retrieved with the following command:
```sh
kubectl get secret/apm-server-quickstart-apm-token -o go-template='{{index .data "secret-token" | base64decode}}'
```

For more information, check [APM Server Reference](https://www.elastic.co/docs/solutions/observability/apm).

## APM Server API keys

If you want to configure API keys to authorize requests to the APM Server, instead of using the APM Server CLI, you have to create API keys using the Elasticsearch  [create API key API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-api-key), check the [APM Server documentation](https://www.elastic.co/docs/solutions/observability/apm/api-keys).