﻿---
title: Configure ECK
description: This section covers ECK configuration mechanisms and use cases, starting with the basic setup of the operator using the provided ConfigMap and extending...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configure
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Configure ECK
This section covers ECK configuration mechanisms and use cases, starting with the basic setup of the operator using the provided `ConfigMap` and extending to more advanced configuration scenarios that require detailed procedures.
<tip>
  This content focuses on ECK operator configuration. For details on available features and how to configure your Elasticsearch and Kibana deployments, refer to [Configure deployments](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configure-deployments).
</tip>

The following guides cover common ECK configuration tasks:
- [Apply ECK configuration settings](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configure-eck): Apply configuration changes, such the CA certificate validity period, the namespaces where the operator is allowed to work, or the log verbosity level for ECK.
- [Configure the validating webhook](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configure-validating-webhook): Enable or disable the webhook, and configure multiple SSL certificate generation options.
- [Restrict cross-namespace resource associations](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/restrict-cross-namespace-resource-associations): Configure access control rules for cross-namespace associations. This functionality is disabled by default.
- [Create custom images](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/create-custom-images): Use your own images with Elasticsearch plugins already installed rather than installing them through init containers.
- [Service meshes](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/service-meshes): Connect ECK and managed Elastic Stack applications to some of the most popular [service mesh](https://www.cncf.io/blog/2017/04/26/service-mesh-critical-component-cloud-native-stack/) implementations in the Kubernetes ecosystem.
- [Network policies](https://www.elastic.co/docs/deploy-manage/security/k8s-network-policies): Use [Kubernetes network policies](https://kubernetes.io/docs/concepts/services-networking/network-policies/) to isolate pods by restricting incoming and outgoing network connections to a trusted set of sources and destinations.
- [Webhook namespace selectors](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/webhook-namespace-selectors): Restrict the namespaces that the validation webhook applies to, allowing multiple operators to coexist efficiently in the same cluster.

Other sections of the Elastic documentation cover additional topics related to ECK configuration:
- **Monitoring**
  - [Configure the metrics endpoint](https://www.elastic.co/docs/deploy-manage/monitor/orchestrators/eck-metrics-configuration)  (monitor an orchestrator)
- **Licensing**
  - [Manage licenses in ECK](https://www.elastic.co/docs/deploy-manage/license/manage-your-license-in-eck)
- **Maintenance**
  - [Upgrade ECK](https://www.elastic.co/docs/deploy-manage/upgrade/orchestrator/upgrade-cloud-on-k8s)
- [Uninstall ECK](https://www.elastic.co/docs/deploy-manage/uninstall/uninstall-elastic-cloud-on-kubernetes)