﻿---
title: Configure deployments
description: This section provides details around Kibana and Elasticsearch configuration when running on ECK. For general information about how ECK applies configuration...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configure-deployments
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Configure deployments
This section provides details around Kibana and Elasticsearch configuration when running on ECK. For general information about how ECK applies configuration changes and the syntax to use in the YAML manifests, refer to [Update your deployments](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/update-deployments).
- [**Elasticsearch configuration**](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elasticsearch-configuration): Review configuration possibilities to tune your Elasticsearch cluster running on ECK, learn how [nodes orchestration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/nodes-orchestration) work, [storage recommendations](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/storage-recommendations), and more.
- [**Kibana configuration**](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/kibana-configuration): Learn how to connect Kibana to an Elasticsearch cluster, apply advanced configuration settings, and tune the HTTP configuration.

Additionally, the following topics apply to both Elasticsearch and Kibana, and in some cases, to other applications supported by ECK:
- [**Users and roles**](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/managed-credentials-eck): Learn how to work with managed credentials, create custom users, and configure authentication realms.
- [**Access services**](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/accessing-services): Learn how to access to the orchestrated clusters and how to adapt the Kubernetes services to your needs.
- [**Customize Pods**](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/customize-pods): Learn how to adapt the `podTemplate` field to your needs.
- [**Manage compute resources**](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/manage-compute-resources): Important considerations around CPU and memory `requests` and `limits` when running production workloads.
- [**Recipes**](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/recipes): Advanced use cases examples available in our GitHub repository.
- [**Connect to external Elastic resources**](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/connect-to-external-elastic-resources): Use custom `secrets` for the `elasticsearchRef` and `kibanaRef` parameters.

ECK also facilitates configuration and operation activities with advanced features, such as:
- [**Secure settings**](https://www.elastic.co/docs/deploy-manage/security/k8s-secure-settings): Configure Elasticsearch and Kibana keystore settings through Kubernetes secrets.
- [**Elastic Stack configuration policies**](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elastic-stack-configuration-policies): Organize your Elasticsearch and Kibana configuration settings through `StackConfigPolicy` resources that can be referenced within your deployments. This helps to keep your manifests simplified.

<important>
  Explore the [Security](https://www.elastic.co/docs/deploy-manage/security) and [Users and roles](https://www.elastic.co/docs/deploy-manage/users-roles) sections to to learn more about how to secure and control access your deployments.
</important>