﻿---
title: Standalone Elastic Agent configuration examples on Elastic Cloud on Kubernetes
description: This section contains manifests that illustrate common use cases, and can be your starting point in exploring Elastic Agent deployed with ECK. These manifests...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configuration-examples-standalone
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Standalone Elastic Agent configuration examples on Elastic Cloud on Kubernetes
This section contains manifests that illustrate common use cases, and can be your starting point in exploring Elastic Agent deployed with ECK. These manifests are self-contained and work out-of-the-box on any non-secured Kubernetes cluster. They all contain a three-node Elasticsearch cluster and a single Kibana instance. Add the corresponding integration package to Kibana to install the dashboards, visualizations and other assets for each of these examples as described in [the Elastic Agent documentation](https://www.elastic.co/docs/reference/fleet/install-elastic-agents).
<warning>
  The examples in this section are for illustration purposes only and should not be considered to be production-ready. Some of these examples use the `node.store.allow_mmap: false` setting which has performance implications and should be tuned for production workloads, as described in [Virtual memory](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/virtual-memory).
</warning>


## System integration

```sh
kubectl apply -f https://raw.githubusercontent.com/elastic/cloud-on-k8s/3.3/config/recipes/elastic-agent/system-integration.yaml
```

Deploys Elastic Agent as a DaemonSet in standalone mode with system integration enabled. Collects syslog logs, auth logs and system metrics (for CPU, I/O, filesystem, memory, network, process and others).

## Kubernetes integration

```sh
kubectl apply -f https://raw.githubusercontent.com/elastic/cloud-on-k8s/3.3/config/recipes/elastic-agent/kubernetes-integration.yaml
```

Deploys Elastic Agent as a DaemonSet in standalone mode with Kubernetes integration enabled. Collects API server, Container, Event, Node, Pod, Volume and system metrics.

## Multiple Elasticsearch clusters output

```sh
kubectl apply -f https://raw.githubusercontent.com/elastic/cloud-on-k8s/3.3/config/recipes/elastic-agent/multi-output.yaml
```

Deploys two Elasticsearch clusters and two Kibana instances together with single Elastic Agent DaemonSet in standalone mode with System integration enabled. System metrics are sent to the `elasticsearch` cluster. Elastic Agent monitoring data is sent to `elasticsearch-mon` cluster.

## Storing local state in host path volume

Elastic Agent managed by ECK stores local state in a host path volume by default. This ensures that Integrations run by the agent can continue their work without duplicating work that has already been done after the Pod has been recreated for example because of a Pod configuration change. Multiple replicas of an agent, for example Fleet Servers, can not be deployed on the same underlying Kubernetes node as they would try to use the same host path. There are 2 options for managing this feature:
1. If local state storage in `hostPath` volumes is not desired this can be turned off by configuring an `emptyDir` volume instead.
2. If local state storage is still desired but running the Agent container as root is not allowed, then you can run a `DaemonSet` that adjusts the permissions for the Agent local state on each Node prior to running Elastic Agent. Note that this `DaemonSet` must be `runAsUser: 0` and possibly `privileged: true`. Also note the Kibana changes required to trust the Elasticsearch CA when running in fleet mode.

Full configuration examples exist in  [Running as a non-root user](/docs/deploy-manage/deploy/cloud-on-k8s/configuration-fleet#k8s-elastic-agent-running-as-a-non-root-user).