﻿---
title: Fleet managed agents configuration examples on Elastic Cloud on Kubernetes
description: This section contains manifests that illustrate common use cases, and can be your starting point in exploring Elastic Agent deployed with ECK. These manifests...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configuration-examples-fleet
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Fleet managed agents configuration examples on Elastic Cloud on Kubernetes
This section contains manifests that illustrate common use cases, and can be your starting point in exploring Elastic Agent deployed with ECK. These manifests are self-contained and work out-of-the-box on any non-secured Kubernetes cluster. They all contain a three-node Elasticsearch cluster, a single Kibana instance and a single Fleet Server instance.
<warning>
  The examples in this section are for illustration purposes only and should not be considered to be production-ready. Some of these examples use the `node.store.allow_mmap: false` setting which has performance implications and should be tuned for production workloads, as described in [Virtual memory](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/virtual-memory).
</warning>


## System and Kubernetes Integrations

```sh
kubectl apply -f https://raw.githubusercontent.com/elastic/cloud-on-k8s/3.3/config/recipes/elastic-agent/fleet-kubernetes-integration.yaml
```

Deploys Elastic Agent as a DaemonSet in Fleet mode with System and Kubernetes Integrations enabled. System integration collects syslog logs, auth logs and system metrics (for CPU, I/O, filesystem, memory, network, process and others). Kubernetes Integrations collects API server, Container, Event, Node, Pod, Volume and system metrics.

## System and Kubernetes Integrations running as non-root

```sh
kubectl apply -f https://raw.githubusercontent.com/elastic/cloud-on-k8s/3.3/config/recipes/elastic-agent/fleet-kubernetes-integration-nonroot.yaml
```

The provided example is functionally identical to the previous section but runs the Elastic Agent processes (both the Elastic Agent running as the Fleet server and the Elastic Agent connected to Fleet) as a non-root user by utilizing a DaemonSet to ensure directory and file permissions.
<note>
  The DaemonSet itself must run as root to set up permissions and ECK >= 2.10.0 is required.
</note>


## Custom logs integration with autodiscover

```sh
kubectl apply -f https://raw.githubusercontent.com/elastic/cloud-on-k8s/3.3/config/recipes/elastic-agent/fleet-custom-logs-integration.yaml
```

Deploys Elastic Agent as a DaemonSet in Fleet mode with Custom Logs integration enabled. Collects logs from all Pods in the `default` namespace using autodiscover feature.

## APM integration

```sh
kubectl apply -f https://raw.githubusercontent.com/elastic/cloud-on-k8s/3.3/config/recipes/elastic-agent/fleet-apm-integration.yaml
```

Deploys single instance Elastic Agent Deployment in Fleet mode with APM integration enabled.

## Synthetic monitoring

```sh
kubectl apply -f https://raw.githubusercontent.com/elastic/cloud-on-k8s/3.3/config/recipes/elastic-agent/synthetic-monitoring.yaml
```

Deploys an Fleet-enrolled Elastic Agent that can be used as for [Synthetic monitoring](https://www.elastic.co/docs/solutions/observability/synthetics). This Elastic Agent uses the `elastic-agent-complete` image. The agent policy still needs to be [registered as private location](/docs/solutions/observability/synthetics/monitor-resources-on-private-networks#synthetics-private-location-add) in Kibana.

## Fleet Server exposed internally and externally

```sh
kubectl apply -f https://raw.githubusercontent.com/elastic/cloud-on-k8s/3.3/config/recipes/elastic-agent/fleet-ingress-setup.yaml
```

This example shows how to expose the Fleet Server to the outside world using a Kubernetes Ingress resource. The Fleet Server is configured to use custom TLS certificates, and all communications are secured with TLS. The same Fleet Server is also accessible from within the cluster, allowing agents to connect to it regardless of their location. Refer to the comments in the `fleet-ingress-setup.yaml` file for more details on how to set up the Ingress resource and TLS certificates to enable this configuration.