﻿---
title: Running ECK in air-gapped environments
description: The ECK operator can be run in an air-gapped environment without access to the open internet when configured to avoid pulling container images from docker.elastic.co...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/air-gapped-install
products:
  - Elastic Cloud on Kubernetes
  - Elastic Stack
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Running ECK in air-gapped environments
The ECK operator can be run in an air-gapped environment without access to the open internet when configured to avoid pulling container images from `docker.elastic.co`.
<note>
  To deploy ECK in Google Distributed Cloud (GDC) air-gapped refer to [Deploy ECK on GDC air-gapped](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/eck-gdch).
</note>

By default ECK does not require you to specify the container image for each Elastic Stack application you deploy.
```yaml
apiVersion: elasticsearch.k8s.elastic.co/v1
kind: Elasticsearch
metadata:
  name: quickstart
spec:
  version: 9.3.0
  # image: docker.elastic.co/elasticsearch/elasticsearch:9.3.0
  nodeSets:
  - name: default
    count: 1
  # podTemplate:
  #   spec:
  #     imagePullSecrets:
  #     - name: private-registry-credentials-secret
```

ECK will automatically set the correct container image for each application. When running in an air-gapped or offline environment you will have to mirror the official Elastic container images in a private container image registry. To make use of your mirrored images you can either set the image for each application explicitly as shown in the preceding example or more conveniently override the default container registry as explained in the next section.

## Use a mirrored image of the ECK operator

To deploy the ECK operator in an air-gapped environment, you first have to mirror the operator image itself from `docker.elastic.co` to a private container registry, for example `my.registry`.
Once the ECK operator image is copied internally, replace the original image name with the private name of the image in the [operator manifests](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/install-using-yaml-manifest-quickstart). For example:
Before:
```text
docker.elastic.co/eck/eck-operator:3.3.0
```

After:
```text
my.registry/eck/eck-operator:3.3.0
```

When using [Helm charts](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/install-using-helm-chart), replace the `image.repository` Helm value with, for example, `my.registry/eck/eck-operator`.

## Override the default container registry

When creating custom resources (Elasticsearch, Kibana, APM Server, Beats, Elastic Agent, Elastic Maps Server, and Logstash), the operator defaults to using container images pulled from the `docker.elastic.co` registry. If you are in an environment where external network access is restricted, you can configure the operator to use a different default container registry by starting the operator with the `--container-registry` command-line flag. Check [*Configure ECK*](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configure-eck) for more information on how to configure the operator using command-line flags and environment variables.
The operator expects container images to be located at specific repositories in the default container registry. Make sure that your container images are stored in the right repositories and are tagged correctly with the Stack version number. For example, if your private registry is `my.registry` and you wish to deploy components from Stack version 9.3.0, the following image names should exist:
- my.registry/elasticsearch/elasticsearch:9.3.0
- my.registry/kibana/kibana:9.3.0
- my.registry/apm/apm-server:9.3.0


## Use a global container repository

If you cannot follow the default Elastic image repositories naming scheme, you can configure the operator to use a different container repository by starting the operator with the `--container-repository` command-line flag. Check [*Configure ECK*](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configure-eck) for more information on how to configure the operator using command-line flags and environment variables.
For example, if your private registry is `my.registry` and all Elastic images are located under the `elastic` repository, the following image names should exist:
- my.registry/elastic/elasticsearch:9.3.0
- my.registry/elastic/kibana:9.3.0
- my.registry/elastic/apm-server:9.3.0


## ECK Diagnostics in air-gapped environments

The [eck-diagnostics tool](https://www.elastic.co/docs/troubleshoot/deployments/cloud-on-k8s/run-eck-diagnostics) optionally runs diagnostics for Elastic Stack applications in a separate container that is deployed into the Kubernetes cluster.
In air-gapped environments with no access to the `docker.elastic.co` registry, you should copy the latest support-diagnostics container image to your internal image registry and then run the tool with the additional flag `--diagnostic-image <custom-support-diagnostics-image-name>`. To find out which support diagnostics container image matches your version of eck-diagnostics, run the tool once without arguments and it will print the default image in use.