﻿---
title: Advanced configuration for APM Server on Elastic Cloud on Kubernetes
description: This section covers the following topics: Use APM Agent central configuration, Customize the APM Server configuration, Specify secure settings for your...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/advanced-configuration
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Advanced configuration for APM Server on Elastic Cloud on Kubernetes
This section covers the following topics:
- [Use APM Agent central configuration](#k8s-apm-agent-central-configuration)
- [Customize the APM Server configuration](#k8s-apm-customize-configuration)
- [Specify secure settings for your APM Server](#k8s-apm-secure-settings)
- [Reference an existing Elasticsearch cluster](#k8s-apm-existing-es)


## Use APM Agent central configuration

<admonition title="Added in 7.5.1">
  APM Agent central configuration was added in 7.5.1.
</admonition>

[APM Agent configuration management](https://www.elastic.co/docs/solutions/observability/apm/apm-server/apm-agent-central-configuration) allows you to configure your APM Agents centrally from the Kibana APM app. To use this feature, the APM Server needs to be configured with connection details of the Kibana instance. If Kibana is managed by ECK, you can simply add a `kibanaRef` attribute to the APM Server specification:
```yaml
cat <<EOF | kubectl apply -f -
apiVersion: apm.k8s.elastic.co/v1
kind: ApmServer
metadata:
  name: apm-server-quickstart
  namespace: default
spec:
  version: 9.3.0
  count: 1
  elasticsearchRef:
    name: quickstart
  kibanaRef:
    name: quickstart
EOF
```

Starting with version 8.0.0 you will also need to ensure that your Kibana instance has the following configuration:
```yaml
apiVersion: kibana.k8s.elastic.co/v1
kind: Kibana
config:
  xpack.fleet.packages:
  - name: apm
    version: latest
```


## Customize the APM Server configuration

To customize the configuration of the APM Server, use the `config` element in the specification:
```yaml
apiVersion: apm.k8s.elastic.co/v1
kind: ApmServer
metadata:
  name: apm-server-quickstart
  namespace: default
spec:
  version: 9.3.0
  count: 1
  config:
    output:
      elasticsearch:
        headers:
          X-My-Header: Just an example of a custom settings
  elasticsearchRef:
    name: quickstart
```

<note>
  The configuration items you provide always override the ones that are generated by the operator.
</note>


## Specify secure settings for your APM Server

The APM Server keystore can be used to store sensitive settings in the APM Server configuration. ECK can automatically manage the APM Server keystore in the Pods.
1. Create a secret with the secret settings:
   ```yaml
   kubectl create secret generic apm-secret-settings --from-literal=ES_PASSWORD=asecretpassword
   ```
2. In the `spec.secureSettings` section, add a reference to the secret you previously created.
   ```yaml
   apiVersion: apm.k8s.elastic.co/v1
   kind: ApmServer
   metadata:
     name: apm-server-quickstart
     namespace: default
   spec:
     version: 9.3.0
     count: 1
     secureSettings:
     - secretName: apm-secret-settings
     config:
       output:
         elasticsearch:
           password: "${ES_PASSWORD}"
   ```
3. Reference the key in the APM Server configuration, as described in the [Secrets keystore for secure settings](https://www.elastic.co/docs/solutions/observability/apm/apm-server/secrets-keystore-for-secure-settings).


## Reference an existing Elasticsearch cluster

Now that you know how to use the APM keystore and customize the server configuration, you can manually configure a secured connection to an existing Elasticsearch cluster.
1. Create a secret with the Elasticsearch CA.
   You need to store the certificate authority of the Elasticsearch cluster in a secret:
   ```yaml
   kubectl create secret generic es-ca --from-file=tls.crt=elasticsearch-ca.crt
   ```
   <note>
   The `elasticsearch-ca.crt` file must contain the CA certificate of the Elasticsearch cluster you want to use with the APM Server.
   </note>
2. Mount this secret using the Pod template, and reference the file in the `config` of the APM Server.
   Here is a complete example with a password stored in the Keystore, as described in the previous section:
   ```yaml
   apiVersion: apm.k8s.elastic.co/v1
   kind: ApmServer
   metadata:
     name: apm-server-quickstart
     namespace: default
   spec:
     version: 9.3.0
     count: 1
     secureSettings:
     - secretName: apm-secret-settings
     config:
       output:
         elasticsearch:
           hosts: ["my-own-elasticsearch-cluster:9200"]
           username: elastic
           password: "${ES_PASSWORD}"
           protocol: "https"
           ssl.certificate_authorities: ["/usr/share/apm-server/config/elasticsearch-ca/tls.crt"]
     podTemplate:
       spec:
         containers:
         - name: apm-server
           volumeMounts:
           - mountPath: /usr/share/apm-server/config/elasticsearch-ca
             name: elasticsearch-ca
             readOnly: true
         volumes:
         - name: elasticsearch-ca
           secret:
             defaultMode: 420
             optional: false
             secretName: es-ca
   ```


## TLS certificates

By default the operator manages a private CA and generates a self-signed certificate used to secure the communication between APM agents and the server.
This behavior and the relevant configuration is identical to what is done for Elasticsearch and Kibana. Check [Setting up your own certificate](https://www.elastic.co/docs/deploy-manage/security/secure-cluster-communications) for more information on how to use your own certificate to configure the TLS endpoint of the APM Server.
For more details on how to configure the APM agents to work with custom certificates, check the [APM agents documentation](https://www.elastic.co/docs/reference/apm-agents).