﻿---
title: Advanced configuration for Logstash on Elastic Cloud on Kubernetes
description: You can change JVM settings by using the LS_JAVA_OPTS environment variable to override default settings in jvm.options. This approach ensures that expected...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/advanced-configuration-logstash
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Advanced configuration for Logstash on Elastic Cloud on Kubernetes
## Setting JVM options

You can change JVM settings by using the `LS_JAVA_OPTS` environment variable to override default settings in `jvm.options`. This approach ensures that expected settings from `jvm.options` are set, and only options that explicitly need to be overridden are.
To do, this, set the  `LS_JAVA_OPTS` environment variable in the container definition of your Logstash resource:
```yaml
apiVersion: logstash.k8s.elastic.co/v1alpha1
kind: Logstash
metadata:
  name: quickstart
spec:
  podTemplate:
    spec:
      containers:
        - name: logstash
          env:
            - name: LS_JAVA_OPTS   
              value: "-Xmx2g -Xms2g"
```


## Setting keystore

You can specify sensitive settings with Kubernetes secrets. ECK automatically injects these settings into the keystore before it starts Logstash. The ECK operator continues to watch the secrets for changes and will restart Logstash Pods when it detects a change.
The Logstash Keystore can be password protected by setting an environment variable called `LOGSTASH_KEYSTORE_PASS`. Check out [Logstash Keystore](https://www.elastic.co/docs/reference/logstash/keystore#keystore-password) documentation for details.
```yaml
apiVersion: v1
kind: Secret
metadata:
  name: logstash-keystore-pass
stringData:
  LOGSTASH_KEYSTORE_PASS: changed   

apiVersion: logstash.k8s.elastic.co/v1alpha1
kind: Logstash
metadata:
  name: logstash-sample
spec:
  version: 9.3.0
  count: 1
  pipelines:
    - pipeline.id: main
      config.string: |-
        input { exec { command => 'uptime' interval => 10 } }
        filter {
          if ("${HELLO:}" != "") {   
            mutate { add_tag => ["awesome"] }
          }
        }
  secureSettings:
    - secretName: logstash-secure-settings
  podTemplate:
    spec:
      containers:
        - name: logstash
          env:
            - name: LOGSTASH_KEYSTORE_PASS
              valueFrom:
                secretKeyRef:
                  name: logstash-keystore-pass
                  key: LOGSTASH_KEYSTORE_PASS
```