﻿---
title: Elastic Cloud on Kubernetes
description: Built on the Kubernetes Operator pattern, Elastic Cloud on Kubernetes (ECK) extends the basic Kubernetes orchestration capabilities to support the setup...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Elastic Cloud on Kubernetes
Built on the Kubernetes Operator pattern, Elastic Cloud on Kubernetes (ECK) extends the basic Kubernetes orchestration capabilities to support the setup and management of Elasticsearch, Kibana, APM Server, Beats, Elastic Agent, Elastic Maps Server, and Logstash on Kubernetes.
<admonition title="Use cloud services in your ECK environment with Cloud Connect">
  With [Cloud Connect](https://www.elastic.co/docs/deploy-manage/cloud-connect), you can use Elastic-managed cloud services in your ECK environment without having to install and manage their infrastructure yourself. In this way, you can get faster access to new features without adding to your operational overhead.
</admonition>


## ECK overview

With Elastic Cloud on Kubernetes, you can streamline critical operations, such as:
1. Managing and monitoring multiple clusters
2. Scaling cluster capacity and storage
3. Performing safe configuration changes through rolling upgrades
4. Securing clusters with TLS certificates
5. Setting up hot-warm-cold architectures with availability zone awareness

This section provides everything you need to install, configure, and manage Elastic Stack applications with ECK, including:
- [Deploy an Elastic Cloud on Kubernetes orchestrator](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/deploy-an-orchestrator): ECK installation methods and configuration options. Deploy ECK on managed Kubernetes platforms like GKE, AKS, and EKS, on self-managed Kubernetes clusters, on OpenShift, and even in air-gapped environments.
- [Manage deployments in Elastic Cloud on Kubernetes](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/manage-deployments): Handle Elasticsearch clusters and Kibana instances through ECK.
- [Orchestrate other Elastic applications](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/orchestrate-other-elastic-applications): Run APM Server, Beats, Elastic Agent, Elastic Maps Server, and Logstash on Kubernetes.
- [Tools and APIs for Elastic Cloud on Kubernetes](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/tools-apis): A collection of tools and APIs available in ECK based environments.

Other sections of the documentation include the following important topics around ECK:
- [Logging and Monitoring](https://www.elastic.co/docs/deploy-manage/monitor): Configure monitoring and logs forwarding with the help of ECK.
- [Remote Clusters](https://www.elastic.co/docs/deploy-manage/remote-clusters): Configure remote clusters on ECK.
- [Backup, high availability, and resilience tools](https://www.elastic.co/docs/deploy-manage/tools): Add snapshot repositories to your Elasticsearch clusters for automatic snapshots.
- [Security](https://www.elastic.co/docs/deploy-manage/security): Secure communications, manage HTTP certificates, or add secure settings to your applications.
- [Users and Roles](https://www.elastic.co/docs/deploy-manage/users-roles): Configure authentication and authorization mechanisms, built-in users, external providers, and more.
- [Autoscaling](https://www.elastic.co/docs/deploy-manage/autoscaling): Learn how to use Elasticsearch autoscaling on ECK, or use Horizontal Pod Autoscaler functionality for stateless workloads.
- [Licensing](https://www.elastic.co/docs/deploy-manage/license/manage-your-license-in-eck): Manage licenses on ECK.

<important>
  ECK is an Elastic self-managed product offered in two licensing tiers: Basic and Enterprise. For more details refer to [Elastic subscriptions](https://www.elastic.co/subscriptions) and [Manage your license in Elastic Cloud on Kubernetes](https://www.elastic.co/docs/deploy-manage/license/manage-your-license-in-eck) documentation.
</important>


## Quickstart

If you want to get started quickly, follow these guides to deploy ECK and set up an Elasticsearch cluster:
- [Install ECK using YAML manifests](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/install-using-yaml-manifest-quickstart)
- [Deploy an Elasticsearch cluster](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elasticsearch-deployment-quickstart)
- [Deploy a Kibana instance](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/kibana-instance-quickstart)

Afterwards, you can:
- Learn how to [update your deployment](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/update-deployments)
- Check out [our recipes](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/recipes) for multiple use cases
- Find further sample resources [in the project repository](https://github.com/elastic/cloud-on-k8s/tree/3.3/config/samples)


## Supported versions

This section outlines the supported Kubernetes and Elastic Stack versions for ECK. Check the full [Elastic support matrix](https://www.elastic.co/support/matrix#matrix_kubernetes) for more information.

### Kubernetes compatibility

ECK is compatible with the following Kubernetes distributions and related technologies:
<applies-switch>
  <applies-item title="eck: ga 3.3+" applies-to="Elastic Cloud on Kubernetes: Generally available since 3.3">
    - Kubernetes 1.31-1.35
    - OpenShift 4.16-4.20
    - Google Kubernetes Engine (GKE), Azure Kubernetes Service (AKS), and Amazon Elastic Kubernetes Service (EKS)
    - Helm: 3.2.0+
  </applies-item>

  <applies-item title="eck: ga =3.2" applies-to="Elastic Cloud on Kubernetes: Generally available in 3.2">
    - Kubernetes 1.30-1.34
    - OpenShift 4.15-4.20
    - Google Kubernetes Engine (GKE), Azure Kubernetes Service (AKS), and Amazon Elastic Kubernetes Service (EKS)
    - Helm: 3.2.0+
  </applies-item>

  <applies-item title="eck: ga =3.1" applies-to="Elastic Cloud on Kubernetes: Generally available in 3.1">
    - Kubernetes 1.29-1.33
    - OpenShift 4.15-4.19
    - Google Kubernetes Engine (GKE), Azure Kubernetes Service (AKS), and Amazon Elastic Kubernetes Service (EKS)
    - Helm: 3.2.0+
  </applies-item>

  <applies-item title="eck: ga =3.0" applies-to="Elastic Cloud on Kubernetes: Generally available in 3.0">
    - Kubernetes 1.28-1.32
    - OpenShift 4.14-4.18
    - Google Kubernetes Engine (GKE), Azure Kubernetes Service (AKS), and Amazon Elastic Kubernetes Service (EKS)
    - Helm: 3.2.0+
  </applies-item>
</applies-switch>

ECK should work with all conformant **installers** listed in these [FAQs](https://github.com/cncf/k8s-conformance/blob/master/faq.md#what-is-a-distribution-hosted-platform-and-an-installer). Distributions include source patches and so may not work as-is with ECK.
Alpha, beta, and stable API versions follow the same [conventions used by Kubernetes](https://kubernetes.io/docs/concepts/overview/kubernetes-api/#api-versioning).

### Elastic Stack compatibility

ECK is compatible with the following Elastic Stack applications:
<applies-switch>
  <applies-item title="eck: ga 3.3+" applies-to="Elastic Cloud on Kubernetes: Generally available since 3.3">
    - Elasticsearch, Kibana, APM Server: 8+, 9+
    - Enterprise Search: 8+
    - Beats: 8+, 9+
    - Elastic Agent: 8+, 9+ (Fleet, standalone)
    - Elastic Maps Server: 8+, 9+
    - Logstash: 8.12+, 9+
  </applies-item>

  <applies-item title="eck: ga 3.0-3.2" applies-to="Elastic Cloud on Kubernetes: Generally available from 3.0 to 3.2">
    - Elasticsearch, Kibana, APM Server: 7.17+, 8+, 9+
    - Enterprise Search: 7.7+, 8+
    - Beats: 7.17+, 8+, 9+
    - Elastic Agent: 7.10+ (standalone), 7.17+ (Fleet), 8+, 9+
    - Elastic Maps Server: 7.17+, 8+, 9+
    - Logstash: 8.12+, 9+
  </applies-item>
</applies-switch>

Elastic Stack application images for the OpenShift-certified Elasticsearch (ECK) Operator are only available from version 7.10 and later.

## Learn more about ECK

- [Orchestrate Elasticsearch on Kubernetes](https://www.elastic.co/elasticsearch-kubernetes)
- [ECK post on the Elastic Blog](https://www.elastic.co/blog/introducing-elastic-cloud-on-kubernetes-the-elasticsearch-operator-and-beyond?elektra=products&storm=sub1)
- [Getting Started With Elastic Cloud on Kubernetes (ECK)](https://www.youtube.com/watch?v=PIJmlYBIFXM)
- [Running the Elastic Stack on Kubernetes with ECK](https://www.youtube.com/watch?v=Wf6E3vkvEFM)