﻿---
title: Manage deployments in Elastic Cloud Enterprise
description: Elastic Cloud Enterprise allows you to manage one or more instances of the Elastic Stack through deployments. A deployment helps you manage an Elasticsearch...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/working-with-deployments
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Manage deployments in Elastic Cloud Enterprise
Elastic Cloud Enterprise allows you to manage one or more instances of the Elastic Stack through **deployments**.
A *deployment* helps you manage an Elasticsearch cluster and instances of other Elastic products, like Kibana or APM, in one place. Spin up, scale, upgrade, and delete your Elastic Stack products without having to manage each one separately. In a deployment, everything works together.
ECE provides a preset of *hardware profiles* that provide a unique blend of storage, memory and vCPU for each component of a deployment. They support a specific purpose, such as a hot-warm architecture, that helps you manage your data storage retention.
All of these profiles are based on [deployment templates](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/deployment-templates), which are a reusable configuration of Elastic products that you can deploy. You can modify existing deployment templates, or create custom deployment templates, to suit your needs.

## Creating deployments

Refer to [Create a deployment](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/create-deployment) to launch and configure an Elastic Stack environment.

## Administering deployments

Maintaining your existing deployments is important. Take a look at the things you can do to keep your deployments and the Elastic Stack running smoothly.
Deployments in ECE are managed from the **Deployment** view of the [Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui). This section focuses on the different actions you can take from this view.

### Configuration and features

From the deployment main page, you can quickly access the following configuration areas:
- Select **Edit** to change the deployment configuration, its components and data tiers. Refer to [Customize your deployment components](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/customize-deployment) for more details.
- Set a [Custom endpoint alias](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-regional-deployment-aliases) to create human-readable URLs for your Elastic Stack applications, making them easier to share and use.
- [Upgrade your deployment](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/upgrade-on-ece) if a newer Elastic Stack version is available.
- Select **Elasticsearch > snapshots** to associate a [snapshots repository](/docs/deploy-manage/tools/snapshot-and-restore/cloud-enterprise#ece-manage-repositories-clusters) with the deployment.
- Select **Monitoring > Logs and metrics** to set up [Stack monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/ece-ech-stack-monitoring) for your deployment, forwarding its logs and metrics to a dedicated monitoring deployment.
  <note>
  In addition to the monitoring of clusters that is described here, don’t forget that Elastic Cloud Enterprise also provides [monitoring information for your entire installation](https://www.elastic.co/docs/deploy-manage/monitor/orchestrators/ece-platform-monitoring).
  </note>


### Security and access control

From the **Deployment > Security** view, you can manage security settings, authentication, and access controls. Refer to [Secure your clusters](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth) for more details on security options for your deployments.
- [Reset the `elastic` user password](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/manage-elastic-user-cloud)
- [Set up IP filters](https://www.elastic.co/docs/deploy-manage/security/ip-filtering-ece) to restrict traffic to your deployment
- Configure Elasticsearch keystore settings, also known as [secure settings](https://www.elastic.co/docs/deploy-manage/security/secure-settings)
- Configure trust relationships for [remote clusters](https://www.elastic.co/docs/deploy-manage/remote-clusters/ece-enable-ccs)


### Endpoints, monitoring, and troubleshooting

From the deployment view, you can directly access endpoints, platform logs and metrics, and troubleshoot issues using various built-in tools.
- Select **Copy endpoint** links to obtain the different URLs to [Connect to Elasticsearch](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/connect-elasticsearch) and [Access Kibana on Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/access-kibana).
- If your deployment includes an integrations server, open the **Integrations server** page to get direct access to APM and Fleet. Refer to [Manage Integrations Server in Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/manage-integrations-server) for more information.
- For Elasticsearch, Kibana, and Integrations Server components, use the **External links** to access each service's logs and metrics, including the associated proxy logs. These logs are part of [ECE platform monitoring](https://www.elastic.co/docs/deploy-manage/monitor/orchestrators/ece-platform-monitoring), and are separate from user-configured stack monitoring.
- Use the [Elasticsearch API console](/docs/deploy-manage/deploy/cloud-enterprise/tools-apis#ece-api-console) to send API calls directly to Elasticsearch.
- [Keep track of your deployment activity](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/keep-track-of-deployment-activity) and get information about configuration changes results and failures.
- Open the **Operations** page to generate and download diagnostics bundles for Elasticsearch and Kibana, and to access other [tools](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/tools-apis).


### Operational actions

Use the **Actions** button at deployment or instance level to:
- [Restart a deployment](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/restart-an-ece-deployment) that has become unresponsive, for example.
- [Terminate a deployment](https://www.elastic.co/docs/deploy-manage/uninstall/delete-a-cloud-deployment) to stop all running instances and delete all data in the deployment.
- [Restore a deployment](/docs/deploy-manage/uninstall/delete-a-cloud-deployment#restore-a-deployment) that had been terminated.
- [Delete a deployment](https://www.elastic.co/docs/deploy-manage/uninstall/delete-a-cloud-deployment) if you no longer need it.
- [Override instance resources](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/resource-overrides) when needed to stabilize your deployment.
- [Stop routing requests or pause deployment instances](https://www.elastic.co/docs/deploy-manage/maintenance/ece/deployments-maintenance) to perform corrective actions that might otherwise be difficult to complete.


## Keeping your clusters healthy

Elastic Cloud Enterprise monitors many aspects of your installation, but some issues require a human to resolve them. Use this section to learn how you can:
- [Find clusters](https://www.elastic.co/docs/troubleshoot/deployments/cloud-enterprise/cloud-enterprise) that have issues.
- [Move affected instances off an allocator](https://www.elastic.co/docs/deploy-manage/maintenance/ece/move-nodes-instances-from-allocators), if the allocator fails.