﻿---
title: Tools and APIs for Elastic Cloud Enterprise
description: Review key resources that can be used to interact with and manage your Elastic Cloud Enterprise installation and deployments. You can use the following...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/tools-apis
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Tools and APIs for Elastic Cloud Enterprise
Review key resources that can be used to interact with and manage your Elastic Cloud Enterprise installation and deployments.

## APIs

You can use the following APIs in an Elastic Cloud Enterprise environment.
<tip>
  Refer to [Elastic API keys](https://www.elastic.co/docs/deploy-manage/api-keys) to learn how to generate API keys for your environment.
</tip>


### Orchestration APIs

You can use the [Elastic Cloud Enterprise RESTful API](https://www.elastic.co/docs/api/doc/cloud-enterprise/) to manage both your Elastic Stack deployments and the ECE platform.
Refer to [Elasticsearch API conventions](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/restful-api) to learn about headers and request body conventions, and view examples.

### APIs to interact with data and solution features

The following APIs allow you to interact with your Elasticsearch cluster, its data, and the features available to you in your Elastic Cloud Enterprise deployments.
<tip>
  Refer to [Elasticsearch API conventions](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/api-conventions) to learn about headers and request body conventions, and to view examples.
</tip>

- [Elasticsearch APIs](https://www.elastic.co/docs/api/doc/elasticsearch/): This set of APIs allows you to interact directly with the Elasticsearch nodes in your deployment. You can ingest data, run search queries, check the health of your clusters, manage snapshots, and more.
- [Kibana APIs](https://www.elastic.co/docs/api/doc/kibana/): Many Kibana features can be accessed through these APIs, including Kibana objects, patterns, and dashboards, as well as user roles and user sessions. You can use these APIs to configure alerts and actions, and to access health details for the [Kibana Task Manager](https://www.elastic.co/docs/deploy-manage/distributed-architecture/kibana-tasks-management).

Some other Elastic products have APIs to support machine-to-machine operations:
- [APM event intake API](https://www.elastic.co/docs/solutions/observability/apm/elastic-apm-events-intake-api)
- [Fleet APIs](https://www.elastic.co/docs/reference/fleet/fleet-api-docs)
- [Logstash APIs](https://www.elastic.co/docs/reference/logstash/monitoring-logstash)


## Elasticsearch API Console

With the Elasticsearch API console, you can interact with a specific Elasticsearch deployment directly from the Elastic Cloud Console or Cloud UI without having to authenticate again. This RESTful API access is limited to the specific cluster and works only for Elasticsearch API calls.
You can find this console in the Elastic Cloud Console or Cloud UI when selecting a specific deployment to manage. From the Elasticsearch menu, select **API Console**.
<note>
  This API Console is different from the [Dev Tools Console](https://www.elastic.co/docs/explore-analyze/query-filter/tools/console) available in Kibana, from which you can call Elasticsearch and Kibana APIs. On the Elasticsearch API Console, you cannot run Kibana APIs.This API console is intended for admin purposes. Avoid running normal workload like indexing or search requests.
</note>


## Elastic Cloud Control: command-line interface for Elastic Cloud

Elastic Cloud Control (ECCTL) is the command-line interface for Elastic Cloud APIs. It wraps typical operations commonly needed by operators within a single command line tool.
ECCTL provides the following benefits:
- Easier to use than the Elastic Cloud Console, Cloud UI, or using the RESTful API directly
- Helps you automate the deployment lifecycle
- Provides a foundation for integration with other tools

Find more details in the [ECCTL documentation](https://www.elastic.co/docs/reference/ecctl).

## Provision hosted deployments with Terraform

<applies-to>
  - Elastic Cloud Serverless: Unavailable
  - Elastic Cloud Hosted: Generally available
</applies-to>

The Elastic Cloud Terraform provider allows you to provision and manage Elastic Cloud Serverless projects, Elastic Cloud Hosted and Elastic Cloud Enterprise deployments as code, and introduce DevOps-driven methodologies to manage and deploy the Elastic Stack and solutions.
To get started, review the [Elastic Cloud Terraform provider documentation](https://registry.terraform.io/providers/elastic/ec/latest/docs) and [Elastic Cloud Terraform GitHub repository](https://github.com/elastic/terraform-provider-ec) for more guidance.

## Other tools

- [ECE scripts](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/scripts): Use these scripts to install Elastic Cloud Enterprise or modify your installation.
- [ECE diagnostics tool](https://www.elastic.co/docs/troubleshoot/deployments/cloud-enterprise/run-ece-diagnostics-tool): Collect logs and metrics related to your ECE installation that you can send to Elastic Support for troubleshooting and investigation purposes.
- [Elasticsearch Support Diagnostic tool](https://www.elastic.co/docs/troubleshoot/elasticsearch/diagnostic): Captures a point-in-time snapshot of cluster statistics and most Elasticsearch settings for troubleshooting purposes.