﻿---
title: Resource overrides
description: Elastic Cloud allocators assign resources to Elasticsearch instances based on RAM, where RAM is proportional to CPU and disk resources. As needed, you...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/resource-overrides
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Resource overrides
Elastic Cloud allocators assign resources to Elasticsearch instances based on RAM, where RAM is proportional to CPU and disk resources. As needed, you can temporarily override the allocated resources to stabilize the deployment. To do this, use the contextual menu available on each instance in the deployment UI.
Overrides are intended to be temporary and may be lost after making configuration changes to the deployment. You should reset overrides as soon as possible, or make them permanent by [changing your configuration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/configure-deployment).
The RAM to CPU proportions can’t be overridden per instance.

## Override disk quota

You can override the RAM to disk storage capacity for an instance under **Override disk quota** from the instance’s drop-down menu. This can be helpful when troubleshooting [watermark errors](https://www.elastic.co/docs/troubleshoot/elasticsearch/fix-watermark-errors) that result in a red [cluster health](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-health) status, which blocks configuration changes. A **Reset system default** message appears while disk quota overrides are set.
<note>
  Overriding the disk storage capacity does not restart the Elasticsearch node.
</note>


## Override RAM, CPU and disk

Alternatively, you can override all resource allocations by selecting **Override instance size** from the instance’s drop-down menu. This overrides the alloted RAM, maintaining a proportional CPU and disk size. This can be helpful if the Elasticsearch cluster is overwhelmed by requests. You should [resize the deployment](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/resize-deployment) when the volume of requests stabilizes.
<note>
  Overriding the instance size restarts the Elasticsearch node.
</note>

When an instance within a deployment has resource overrides, it displays a warning banner reading **Elastic added temporary capacity to stabilize the deployment**. [Configuration changes](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/working-with-deployments) can still be safely submitted.

## Disabling CPU quotas at deployment level

In addition to overriding resources for individual instances, you can also completely disable CPU limits for your deployment from the **Operations** page of each deployment.
<note>
  When running ECE on Podman, CPU quotas for existing instances cannot be removed or updated. As a result, disabling the CPU hard limit has no effect on Podman-based allocators.
</note>

<important>
  Disabling the CPU hard limit for an entire deployment is an advanced action and should be approached with caution. This setting removes CPU quotas from the containers, which means some instances could consume excessive CPU resources and degrade the performance of other instances running on the same allocators.We strongly recommend making this change only under the guidance of Elastic Support, and only as a temporary measure or for troubleshooting purposes.
</important>

To disable CPU limits of your deployment instances, choose one of the following methods:
- Open the **Operations** page of the deployment UI, and select **Turn off** in the **CPU hard limit** section.
- Use the [advanced editor](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/advanced-cluster-configuration), and in the **Elasticsearch cluster data** section, look for the following setting:
  ```yaml
        "resources": {
          "cpu": {
            "hard_limit": false
          }
        }
  ```
  Set `hard_limit` to `false` to disable CPU limits, or to `true` to enforce strict CPU limits (default behavior).

This change doesn’t require a restart of the deployment.