﻿---
title: Prepare your environment
description: In this section you'll find all the prerequisites and environment preparations required to properly plan and install Elastic Cloud Enterprise (ECE). In...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/prepare-environment
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Prepare your environment
In this section you'll find all the prerequisites and environment preparations required to properly plan and install Elastic Cloud Enterprise (ECE).

## Requirements

In Elastic Cloud Enterprise, an ECE host is the server, virtual machine, or cloud instance where the ECE software is installed. An ECE installation consists of a cluster of multiple hosts, forming the platform where Elastic Stack applications are orchestrated.
To prepare your hosts for installation, the following prerequisites **must** be met:
<important>
  These prerequisites are critical to establish a supported ECE configuration. Using unsupported combinations can cause a number of either intermediate or potentially permanent issues with your ECE environment, such as failures to create [system deployments](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/system-deployments-configuration), failures to upgrade workload deployments, proxy timeouts, data loss, and more. If upgrading ECE, read [upgrade your installation](https://www.elastic.co/docs/deploy-manage/upgrade/orchestrator/upgrade-cloud-enterprise) for guidance.
</important>

- [Hardware prerequisites](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-hardware-prereq)
- [Software prerequisites](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-software-prereq)
- [System configuration prerequisites](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-sysconfig)
- [Networking prerequisites](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-networking-prereq)
- [Users and permissions prerequisites](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-users-permissions)


## Best practices and recommendations

Follow these best practices to properly prepare your ECE installation:
- [High availability](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-ha) - For production and mission-critical systems, high availability **must** be considered
- [Separation of roles](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-roles) - To group components on ECE and prevent conflicting workloads, consider role separation
- [Load balancers](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-load-balancers) - Using a load balancer is **strongly recommended**
- [JVM heap sizes](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-jvm) - Configure the proper JVM heap size based on your use cases
- [Wildcard DNS record](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-wildcard-dns) - Configure your own wildcard DNS record for production systems
- [Manage installation capacity](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-manage-capacity) - Configure your memory, CPU quotas, processors and storage properly