﻿---
title: Post-installation steps
description: After your Elastic Cloud Enterprise installation is up, some additional steps might be required. For a complete list of configurable features in ECE,...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/post-installation-steps
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Post-installation steps
After your Elastic Cloud Enterprise installation is up, some additional steps might be required. For a complete list of configurable features in ECE, refer to [Configure ECE](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/configure).
<tip>
  To start creating Elasticsearch deployments directly, refer to [Manage deployments in Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/working-with-deployments).
</tip>

- Add your own [load balancer](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-load-balancers). Load balancers are user supplied and we do not currently provide configuration steps for you.
- [Add more capacity](https://www.elastic.co/docs/deploy-manage/maintenance/ece/scale-out-installation) to your ECE installation, [resize your deployment](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/resize-deployment), [upgrade to a newer Elasticsearch version](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/upgrade-on-ece), and [add some plugins](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/add-plugins).
- [Configure ECE system deployments](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/system-deployments-configuration) to ensure a highly available and resilient setup.
- [Configure ECE for deployment templates](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/configure-deployment-templates) to indicate what kind of hardware you have available for Elastic Stack deployments.
- In production systems, add your own [Cloud UI and Proxy certificates](https://www.elastic.co/docs/deploy-manage/security/secure-your-elastic-cloud-enterprise-installation/manage-security-certificates) to enable secure connections over HTTPS. The proxy certificate must be a wildcard certificate signed for the needed DNS records of your domain.
  <note>
  The default DNS resolution provided by Elastic is not intended for production use. Refer to [Wildcard DNS record and certificates](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-wildcard-dns) for more information.If you intend to use [custom endpoint aliases](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/enable-custom-endpoint-aliases) functionality, ensure you add the necessary Subject Alternative Name (SAN) entries to the proxy certificate.
  </note>
- Optionally, if you want the deployment endpoint links and Single-sign on to work with your domain name, configure it as the **deployment domain name** in the **Platform** > **Settings** section of the [Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui). The domain name is used to generate the endpoint URLs and must align with your proxy certificate and DNS record.
  <tip>
  For example, if your proxy certificate is signed for `*.elastic-cloud-enterprise.example.com` and you have a wildcard DNS register pointing `*.elastic-cloud-enterprise.example.com` to your load balancer, you should configure `elastic-cloud-enterprise.example.com` as the **deployment domain name** in Platform → Settings. Refer to [Change endpoint URLs](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/change-endpoint-urls) for more details.
  </tip>
- [Add a snapshot repository](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-enterprise) to enable regular backups of your Elasticsearch clusters.
- [Add more platform users](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator/manage-users-roles) with role-based access control.
- Consider enabling encryption-at-rest (EAR) on your hosts.
  <note>
  Encryption-at-rest is not implemented out of the box in Elastic Cloud Enterprise. [Learn more](/docs/deploy-manage/security/secure-your-elastic-cloud-enterprise-installation#ece_encryption).
  </note>
- Set up [traffic filters](https://www.elastic.co/docs/deploy-manage/security/network-security) to restrict traffic to your deployment to only trusted IP addresses or VPCs.
- Learn how to work around host maintenance or a host failure by [moving nodes off of an allocator](https://www.elastic.co/docs/deploy-manage/maintenance/ece/move-nodes-instances-from-allocators). For an overview of common ECE maintenance activities, refer to [ECE maintenance](https://www.elastic.co/docs/deploy-manage/maintenance/ece).
- If you received a license from Elastic, [manage the licenses](https://www.elastic.co/docs/deploy-manage/license/manage-your-license-in-ece) for your Elastic Cloud Enterprise installation.

<warning>
  During installation, the system generates secrets that are placed into the `/mnt/data/elastic/bootstrap-state/bootstrap-secrets.json` secrets file, unless you passed in a different path with the --host-storage-path parameter. Keep the information in the `bootstrap-secrets.json` file secure by removing it from its default location and placing it into a secure storage location.
</warning>