﻿---
title: Migrating to Podman 5
description: This guide describes the supported ways to upgrade or migrate your Elastic Cloud Enterprise (ECE) hosts to Podman 5. There are two primary methods: In-place...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/migrate-to-podman-5
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Migrating to Podman 5
This guide describes the supported ways to upgrade or migrate your Elastic Cloud Enterprise (ECE) hosts to Podman 5. There are two primary methods:
- **In-place upgrade**: Update Podman directly on existing ECE hosts without replacing them. In-place upgrades to Podman 5 are only supported from existing Podman-based hosts.
- **Grow-and-shrink upgrade**: [Add new hosts](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/install-ece-on-additional-hosts) running the desired Podman version to your ECE installation, then [remove the old ones](https://www.elastic.co/docs/deploy-manage/uninstall/uninstall-elastic-cloud-enterprise). This method is safer and preferred, as it avoids potential risks associated with upgrading the container engine or the operating system in place.

ECE supports Podman 5, regardless of your upgrade method. Refer to the official [Support matrix](https://www.elastic.co/support/matrix#elastic-cloud-enterprise) for details on supported versions.
<important>
  Podman versions `5.2.2-11` and `5.2.2-13` are affected by a known [memory leak issue](https://github.com/containers/podman/issues/25473). To avoid this issue, use a later Podman version.
</important>

The following table summarizes the supported upgrade paths to Podman 5 in ECE.

| **From ↓** ...       **To →**           | Podman 5 |
|-----------------------------------------|----------|
| **<vanilla Linux installation> (grow)** | ✓        |
| **Docker (grow-and-shrink)**            | ✓        |
| **Podman 4.9.4 (grow-and-shrink)**      | ✓        |
| **Podman 4.9.4 (in-place)**             | ✓        |
| **Podman 5.2.2 (grow-and-shrink)**      | ✓        |
| **Podman 5.2.2 (in-place)**             | ✓        |

As shown in the table above, [migrations from Docker](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/migrate-ece-to-podman-hosts) are only supported using the grow-and-shrink method.