﻿---
title: Install Elastic Cloud Enterprise
description: You can deploy Elastic Cloud Enterprise (ECE) on public or private clouds, virtual machines, or on-premises. In ECE, a host refers to any server, VM,...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/install
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Install Elastic Cloud Enterprise
You can deploy Elastic Cloud Enterprise (ECE) on public or private clouds, virtual machines, or on-premises.
<tip>
  If you already have an ECE platform up and running, and you want to add hosts to your installation, refer to [Install ECE on additional hosts](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/install-ece-on-additional-hosts).
</tip>

In ECE, a host refers to any server, VM, or cloud instance where the ECE software is installed. An ECE platform consists of multiple hosts working together to orchestrate Elastic Stack applications.
For public cloud deployments, you can choose from the following providers:
- Amazon Web Services (AWS)
- Google Cloud Platform (GCP)
- Microsoft Azure

<note>
  In these pages we frequently refer to [Docker](https://www.docker.com/), as its currently the most common container engine, but these instructions are generally valid for [Podman](https://podman.io/) as well, with `podman` replacing `docker` in commands as appropriate.
</note>


## Prerequisites

Before you start, make sure to [identify your deployment scenario](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/identify-deployment-scenario) and follow all the referenced sections in [Prepare your environment](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/prepare-environment). Make sure that your selected infrastructure meets the requirements.

## Configure your ECE hosts

After completing the prerequisites, proceed to configure your ECE hosts. This includes installing Docker or Podman, setting up XFS quotas, preparing mount points, and other required configurations.
<important>
  Make sure to use a supported combination of Linux distribution and container engine version as defined in our official [Support matrix](https://www.elastic.co/support/matrix#elastic-cloud-enterprise). Unsupported combinations can lead to various issues in your ECE environment, including failures when creating system deployments, upgrading workload deployments, proxy timeouts, and more.
  FIPS (Federal Information Processing Standards) compliance is not officially supported in ECE. While ECE may function on FIPS-enabled systems, this configuration has not been validated through our testing processes and is not recommended for production environments.
</important>

ECE supports a [wide range of OS versions](https://www.elastic.co/support/matrix#elastic-cloud-enterprise). Below are some OS-specific instructions for preparing your hosts, though other versions follow a similar process. Choose the appropriate guide for your operating system and follow the instructions:
- [Ubuntu 20.04 LTS (Focal Fossa) and Ubuntu 22.04 LTS (Jammy Jellyfish)](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/configure-host-ubuntu)
- [Red Hat Enterprise Linux (RHEL) 8 and 9](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/configure-host-rhel)
- [Rocky Linux 8 and 9](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/configure-host-rhel)
- [SUSE Linux Enterprise Server (SLES) 12 SP5 and 15](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/configure-host-suse)

<important>
  Cloud providers default provide automatic operating system patching for their virtual machines. We strongly recommend disabling this feature to avoid potential data loss and installation failure. All patching should be done using the [Perform host maintenance](https://www.elastic.co/docs/deploy-manage/maintenance/ece/perform-ece-hosts-maintenance) instructions.
</important>


## Install ECE

To install ECE with the official bash script, follow the instructions for the [deployment scenario](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/identify-deployment-scenario) that best fits your business needs:
- [Deploy a small installation](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/deploy-small-installation): For development, test, and small-scale use cases.
- [Deploy a medium installation](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/deploy-medium-installation): For many production setups.
- [Deploy a large installation](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/deploy-large-installation): For deployments with significant overall search and indexing throughput.
- [Deploy using Podman](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/fresh-installation-of-ece-using-podman-hosts): Fresh installation of ECE using Podman hosts.

Alternatively, you can install ECE with the [Ansible](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/alternative-install-ece-with-ansible) playbook. The ECE Ansible playbook is a community project, supported by Elastic, aimed at installing ECE at scale.
To install ECE in an air-gapped environment, refer to [Air-gapped install](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/air-gapped-install).

## Post-installation steps

Once you have installed ECE, check some final [post-installation steps](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/post-installation-steps) to get ready for production.