﻿---
title: Enable custom endpoint aliases
description: Custom endpoint aliases allow users to replace the UUID for each application with a human readable string. Platform administrators must enable this feature...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/enable-custom-endpoint-aliases
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Enable custom endpoint aliases
Custom endpoint aliases allow users to replace the UUID for each application with a human readable string. Platform administrators must enable this feature to allow deployment managers to create and modify aliases for their deployments.
<note>
  You need to update your proxy certificates to support this feature.
</note>

After installing or upgrading to version 2.10 or later:
1. [Login to the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui)
2. [Update your proxy certificate(s)](https://www.elastic.co/docs/deploy-manage/security/secure-your-elastic-cloud-enterprise-installation/manage-security-certificates). In addition to currently configured domains, additional SAN entries must be configured for each application-specific subdomain:
   <note>
   If you are not using wildcard certificates, you need to repeat this process for each deployment to account for specific aliases. Review [Wildcard DNS record and certificates](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-wildcard-dns) for more guidance.
   </note>
   - For Elasticsearch, the certificate needs to allow for ***.es.<your-domain>**
- For Kibana, the certificate needs to allow for ***.kb.<your-domain>**
- For APM, the certificate needs to allow for ***.apm.<your-domain>**
- For Fleet, the certificate needs to allow for ***.fleet.<your-domain>**
- For Universal Profiling, the certificate needs to allow for ***.profiling.<your-domain>** and ***.symbols.<your-domain>**
3. In the **Platform** menu, select **Settings**.
4. Under the **Enable custom endpoint alias naming**, toggle the setting to allow platform administrators and deployment managers to choose a simplified, unique URL for the endpoint.