﻿---
title: Edit stack user settings
description: From the Elastic Cloud Enterprise console you can customize settings for Elasticsearch, Kibana, and other Elastic Stack components by applying user settings...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/edit-stack-settings
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Edit stack user settings
From the Elastic Cloud Enterprise console you can customize settings for Elasticsearch, Kibana, and other Elastic Stack components by applying **user settings** to your deployments. These settings are internally mapped to the appropriate YAML configuration files, such as `elasticsearch.yml` and `kibana.yml`, and they affect all users of that cluster.
To customize the settings of a deployment's Elastic Stack components:
1. Open your deployment page in the ECE [Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. In the left navigation menu, select **Edit**.
3. Look for the **Manage user settings and extensions** and **Edit user settings** links for each deployment, and select the one corresponding to the component you want to update, such as Elasticsearch or Kibana.
4. Apply the necessary settings in the **Users Settings** tab of the editor and select **Back** when finished.
5. Select **Save** to apply the changes to the deployment. Saving your changes initiates a configuration plan change that restarts the affected components for you.

The following sections provide extra details and examples for different components:
- [Add Elasticsearch user settings](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/edit-stack-settings-elasticsearch)
- [Add Kibana user settings](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/edit-stack-settings-kibana)
- [Add APM user settings](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/edit-stack-settings-apm)
- [Add Enterprise Search user settings](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/edit-stack-settings-enterprise)