﻿---
title: Add Elasticsearch user settings
description: Change how Elasticsearch runs by providing your own user settings. User settings are appended to the elasticsearch.yml configuration file for your cluster...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/edit-stack-settings-elasticsearch
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Add Elasticsearch user settings
Change how Elasticsearch runs by providing your own user settings. User settings are appended to the `elasticsearch.yml` configuration file for your cluster and provide custom configuration options.
<important>
  If a feature requires both standard `elasticsearch.yml` settings and [secure settings](https://www.elastic.co/docs/deploy-manage/security/secure-settings), configure the secure settings first. Updating standard user settings can trigger a cluster rolling restart, and if the required secure settings are not yet in place, the nodes might fail to start. Adding secure settings does not trigger a restart.
</important>

Elastic Cloud Enterprise automatically rejects `elasticsearch.yml` settings that could break your cluster, including some zen discovery and security settings. For a detailed list of settings, refer to the [Elasticsearch configuration reference](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference).
<note>
  Most of the user settings that are available for the Elasticsearch version that your cluster is running are also available on Elastic Cloud Enterprise, regardless of being marked as "supported on Elastic Cloud Hosted".
</note>

To add or edit Elasticsearch user settings:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. On the **Deployments** page, select your deployment.
   Narrow the list by name, ID, or choose from several other filters. To further define the list, use a combination of filters.
3. From your deployment menu, go to the **Edit** page.
4. In the **Elasticsearch** section, select **Manage user settings and extensions**. For deployments with existing user settings, you may have to expand the **User setting overrides** caret for each node type instead.
5. Update the user settings.
6. Select **Save changes**.
   <warning>
   If you encounter the **Edit elasticsearch.yml** carets, be sure to make your changes on all Elasticsearch node types.
   </warning>



## Example: enable email notifications

To enable email notifications in your Elasticsearch cluster, you need to configure an email account and related settings. For complete instructions, refer to [Configuring email accounts](/docs/explore-analyze/alerts-cases/watcher/actions-email#configuring-email).
```yaml
xpack.notification.email.account:
    gmail_account:
        profile: gmail
        smtp:
            auth: true
            starttls.enable: true
            host: smtp.gmail.com
            port: 587
            user: <username>
```

Before you add the `xpack.notification.email*` user settings, make sure to store the SMTP password in the keystore as a [secure setting](https://www.elastic.co/docs/deploy-manage/security/secure-settings). In the previous example, use the key `xpack.notification.email.account.gmail_account.smtp.secure_password`.