﻿---
title: Add APM user settings
description: Starting in Elastic Stack version 8.0, how you change APM settings and the settings that are available to you depend on how you spin up Elastic APM. There...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/edit-stack-settings-apm
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Add APM user settings
Starting in Elastic Stack version 8.0, how you change APM settings and the settings that are available to you depend on how you spin up Elastic APM. There are two modes:
<definitions>
  <definition term="Fleet-managed APM integration">
    New deployments created in Elastic Stack version 8.0 and later will be managed by Fleet.
    - This mode requires SSL/TLS configuration. Check [TLS configuration for Fleet-managed mode](#ece-edit-apm-fleet-tls) for details.
    - Check [APM integration input settings](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure) for all other Elastic APM configuration options in this mode.
  </definition>
  <definition term="Standalone APM Server (legacy)">
    Deployments created prior to Elastic Stack version 8.0 are in legacy mode. Upgrading to or past Elastic Stack 8.0 does not remove you from legacy mode.
    Check [Edit standalone APM settings (legacy)](#ece-edit-apm-standalone-settings-ece) for information on how to configure Elastic APM in this mode.
  </definition>
</definitions>

To learn more about the differences between these modes, or to switch from Standalone APM Server (legacy) mode to Fleet-managed, check [Switch to the Elastic APM integration](https://www.elastic.co/docs/solutions/observability/apm/switch-to-elastic-apm-integration).

## TLS configuration for Fleet-managed mode

Users running Elastic Stack versions 7.16 or 7.17 need to manually configure TLS. This step is not necessary for Elastic Stack versions ≥ 8.0.
Pick one of the following options:
1. Upload and configure a publicly signed Elasticsearch TLS certificates. Check [Encrypt traffic in clusters with a self-managed Fleet Server](https://www.elastic.co/docs/reference/fleet/secure-connections) for details.
2. Change the Elasticsearch hosts where Elastic Agents send data from the default public URL, to the internal URL. In Kibana, navigate to **Fleet** and select the **Elastic Cloud agent policy**. Click **Fleet settings** and update the Elasticsearch hosts URL. For example, if the current URL is `https://123abc.us-central1.gcp.foundit.no:9244`, change it to `http://123abc.containerhost:9244`.


## Edit standalone APM settings (legacy)

Elastic Cloud Enterprise supports most of the legacy APM settings. Through a YAML editor in the console, you can append your APM Server properties to the `apm-server.yml` file. Your changes to the configuration file are read on startup.
<important>
  Be aware that some settings could break your cluster if set incorrectly and that the syntax might change between major versions. Before upgrading, be sure to review the full list of the [latest APM settings and syntax](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure).
</important>

To change APM settings:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. On the **Deployments** page, select your deployment.
   Narrow the list by name, ID, or choose from several other filters. To further define the list, use a combination of filters.
3. From your deployment menu, go to the **Edit** page.
4. In the **APM** section, select **Edit user settings**. (For existing deployments with user settings, you may have to expand the **Edit apm-server.yml** caret instead.)
5. Update the user settings.
6. Select **Save changes**.

<note>
  If a setting is not supported by Elastic Cloud Enterprise, you get an error message when you try to save. We suggest changing one setting with each save, so you know which one is not supported.
</note>


## Examples


### Enable RUM and increase the rate limit (legacy)

When capturing the user interaction with clients with real user monitoring (RUM), particularly for situations with concurrent clients, you can increase the number of times each IP address can send a request to the RUM endpoint. Version 6.5 includes an additional settings for the LRU cache.
For APM Server with RUM agent version 2.x or 3.x:
```sh
apm-server:
  rum:
    enabled: true
    event rate:
      limit: 3000
      lru_size: 5000
```


### Disable RUM (legacy)

If you know that you won’t be tracking RUM data, you can disable the endpoint proactively.
```sh
apm-server:
  rum:
    enabled: false
```


### Adjust the event limits configuration (legacy)

If the size of the HTTP request frequently exceeds the maximum, you might need to change the limit on the APM Server and adjust the relevant settings in the agent.
```sh
apm-server:
  max_event_size: 407200
```