﻿---
title: JVM heap size
description: When you install ECE specify the recommended JVM heap sizes with --memory-settings JVM_SETTINGS parameter, based on the use cases as described below: 
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-jvm
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# JVM heap size
<important>
  ECE uses default JVM heap sizes for services that work for testing. Make sure to configure the JVM heap size that fits your use case. Not following the recommended settings may cause issues later on as volume of data and usage increases.
</important>

When you install ECE specify the recommended JVM heap sizes with `--memory-settings JVM_SETTINGS` parameter, based on the use cases as described below:
- [Deploy a small installation](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/deploy-small-installation): For development, test, and small-scale use cases.
- [Deploy a medium installation](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/deploy-medium-installation): For many production setups.
- [Deploy a large installation](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/deploy-large-installation): For deployments with significant overall search and indexing throughput.

Other JVM heap sizes can be left at their defaults.
<note>
  In the current release, there is no direct way to change the Java heap size in the UI. In case you need to configure the settings after ECE installation, refer to [Cloud UI login failures](/docs/troubleshoot/deployments/cloud-enterprise/common-issues#ece-issues-login-failure) for further guidance.
</note>