﻿---
title: Air-gapped install with a private Docker registry
description: Installing ECE on multiple hosts with your own registry server is simpler, because you do not have to load the Docker images on each host. Set up your...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-install-offline-with-registry
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Air-gapped install with a private Docker registry
Installing ECE on multiple hosts with your own registry server is simpler, because you do not have to load the Docker images on each host.
1. Set up your private Docker registry. To learn more, check [Deploy a registry server](https://docs.docker.com/registry/deploying/).
   <tip>
   As part of the ECE [high availability](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-ha) strategy, it’s a good idea to make sure that your Docker registry server is available to all ECE allocators, so that it can continue to be accessed in the event of a network partition or zone outage. Allocators attempting to start instances requiring Docker images that have not yet been pulled from a custom Docker registry will fail to start if the registry is unavailable.
   </tip>
2. On an internet-connected host with Docker installed, download the Docker images required by the Elastic Cloud Enterprise version you want to install. Refer to [available docker images](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-install-offline-images) for more information.
   For example, for Elastic Cloud Enterprise 4.0.3 and the Elastic Stack versions it includes, you need:
   ```sh
   docker pull docker.elastic.co/cloud-enterprise/elastic-cloud-enterprise:4.0.3
   docker pull docker.elastic.co/cloud-release/elasticsearch-cloud-ess:8.18.8
   docker pull docker.elastic.co/cloud-release/kibana-cloud:8.18.8
   docker pull docker.elastic.co/cloud-release/elastic-agent-cloud:8.18.8
   docker pull docker.elastic.co/cloud-release/enterprise-search-cloud:8.18.8
   docker pull docker.elastic.co/cloud-release/elasticsearch-cloud-ess:9.0.8
   docker pull docker.elastic.co/cloud-release/kibana-cloud:9.0.8
   docker pull docker.elastic.co/cloud-release/elastic-agent-cloud:9.0.8
   ```
   <note>
   Version 8.x images are required for system deployments.
   </note>
3. Tag the Docker images with your private registry URL by replacing `REGISTRY` with your actual registry address, for example `my.private.repo:5000`:
   ```sh
   docker tag docker.elastic.co/cloud-enterprise/elastic-cloud-enterprise:4.0.3 REGISTRY/cloud-enterprise/elastic-cloud-enterprise:4.0.3
   docker tag docker.elastic.co/cloud-release/elasticsearch-cloud-ess:8.18.8 REGISTRY/cloud-release/elasticsearch-cloud-ess:8.18.8
   docker tag docker.elastic.co/cloud-release/kibana-cloud:8.18.8 REGISTRY/cloud-release/kibana-cloud:8.18.8
   docker tag docker.elastic.co/cloud-release/elastic-agent-cloud:8.18.8 REGISTRY/cloud-release/elastic-agent-cloud:8.18.8
   docker tag docker.elastic.co/cloud-release/enterprise-search-cloud:8.18.8 REGISTRY/cloud-release/enterprise-search-cloud:8.18.8
   docker tag docker.elastic.co/cloud-release/elasticsearch-cloud-ess:9.0.8 REGISTRY/cloud-release/elasticsearch-cloud-ess:9.0.8
   docker tag docker.elastic.co/cloud-release/kibana-cloud:9.0.8 REGISTRY/cloud-release/kibana-cloud:9.0.8
   docker tag docker.elastic.co/cloud-release/elastic-agent-cloud:9.0.8 REGISTRY/cloud-release/elastic-agent-cloud:9.0.8
   ```
4. Push the Docker images to your private Docker registry, using the same tags from the previous step. Replace `REGISTRY` with your actual registry URL, for example `my.private.repo:5000`:
   ```sh
   docker push REGISTRY/cloud-enterprise/elastic-cloud-enterprise:4.0.3
   docker push REGISTRY/cloud-release/elasticsearch-cloud-ess:8.18.8
   docker push REGISTRY/cloud-release/kibana-cloud:8.18.8
   docker push REGISTRY/cloud-release/elastic-agent-cloud:8.18.8
   docker push REGISTRY/cloud-release/enterprise-search-cloud:8.18.8
   docker push REGISTRY/cloud-release/elasticsearch-cloud-ess:9.0.8
   docker push REGISTRY/cloud-release/kibana-cloud:9.0.8
   docker push REGISTRY/cloud-release/elastic-agent-cloud:9.0.8
   ```
5. On an internet-connected host, download the installation script:
   ```sh
   curl -L -O https://download.elastic.co/cloud/elastic-cloud-enterprise.sh
   ```
6. Copy the installation script to each host where you plan to install Elastic Cloud Enterprise or make it available on your network.
7. Invoke the installation script on each host with the `--docker-registry REGISTRY` parameter, replacing `REGISTRY` with your actual registry URL (for example `my.private.repo:5000`):
   <note>
   Refer to [ECE installation procedures](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/install-ece-procedures) for more details on the parameters to pass to the installation script depending on the size of your installation.
   </note>
   1. On the first host:
   ```sh
   bash elastic-cloud-enterprise.sh install
     --docker-registry REGISTRY
   ```
2. On additional hosts, include the `--coordinator-host HOST_IP` and `--roles-token 'TOKEN'` parameters provided to you when you installed on the first host, along with the `--docker-registry REGISTRY` parameter:
   ```sh
   bash elastic-cloud-enterprise.sh install
     --coordinator-host HOST_IP
     --roles-token 'TOKEN'
     --docker-registry REGISTRY
   ```
   Once the installation is complete, refer to [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui) to access Cloud UI.