﻿---
title: Deploy a small installation
description: The type of installation is recommended for development, test, and small-scale use cases. You need: 3 hosts with 128 GB RAM, 3 availability zones. This...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/deploy-small-installation
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Deploy a small installation
The type of installation is recommended for development, test, and small-scale use cases. You need:
- 3 hosts with 128 GB RAM
- 3 availability zones

![A small baseline installation with three hosts across three availability zones](https://www.elastic.co/docs/deploy-manage/images/cloud-enterprise-ece-pb-3.png)


## Important considerations

- This type of installation is **not recommended for high-traffic workloads**.
- You must not use **spinning disks** with small ECE installations, as these are not supported when you run allocators and ECE management services on the same server.
- Note that the small-size ECE installation keeps the directors and coordinators roles (ECE management services) on the same hosts as your allocators and proxies.

**Check the recommended JVM Heap sizes**

| Service         | JVM Heap Size (Xms and Xmx) |
|-----------------|-----------------------------|
| `runner`        | 1 GB                        |
| `allocator`     | 4 GB                        |
| `zookeeper`     | 4 GB                        |
| `director`      | 1 GB                        |
| `constructor`   | 4 GB                        |
| `admin-console` | 4 GB                        |

<warning>
  For production environments, you must define the memory settings for each role, except for the `proxy` role, as starting from ECE 2.4 the JVM proxy was replaced with a Golang-based proxy. If you don’t set any memory setting, the default values are used, which are inadequate for production environments and can lead to performance or stability issues.
</warning>


## Before you start

Make sure you have completed all prerequisites and environment preparations described in the [Installation overview](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/install), and that the hosts are configured according to [Configure your operating system](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/configure-operating-system).

## Installation steps

1. Install Elastic Cloud Enterprise on the first host to start a new installation with your first availability zone. This first host holds all roles to help bootstrap the rest of the installation.
   ```sh
   bash <(curl -fsSL https://download.elastic.co/cloud/elastic-cloud-enterprise.sh) install --availability-zone MY_ZONE-1 --memory-settings '{"runner":{"xms":"1G","xmx":"1G"},"allocator":{"xms":"4G","xmx":"4G"},"zookeeper":{"xms":"4G","xmx":"4G"},"director":{"xms":"1G","xmx":"1G"},"constructor":{"xms":"4G","xmx":"4G"},"admin-console":{"xms":"4G","xmx":"4G"}}'
   ```
   After the installation completes, copy down the coordinator host IP address, user credentials, and roles token information. Keep this information safe.
2. Generate a new roles token that persists for one hour on the first host, so that other hosts can join your installation with the right role permissions in the next step (referred to as `MY_TOKEN`). The new token needs to enable all host roles, which none of the tokens automatically generated by the installation on the first host provide.
   ```sh
   curl -k -H 'Content-Type: application/json' -u admin:PASSWORD https://localhost:12443/api/v1/platform/configuration/security/enrollment-tokens -d '{ "persistent": false, "roles": ["director", "coordinator", "proxy", "allocator"] }'
   ```
3. Install Elastic Cloud Enterprise on a second and third host, placing them into a second and a third availability zone, and assign them the same roles and memory settings as the first host. Make sure you include the coordinator host IP information from step 1 and the new roles token from step 2.
   ```sh
   bash <(curl -fsSL https://download.elastic.co/cloud/elastic-cloud-enterprise.sh) install --coordinator-host HOST_IP --roles-token 'MY_TOKEN' --roles "director,coordinator,proxy,allocator" --availability-zone MY_ZONE-2 --memory-settings '{"runner":{"xms":"1G","xmx":"1G"},"allocator":{"xms":"4G","xmx":"4G"},"zookeeper":{"xms":"4G","xmx":"4G"},"director":{"xms":"1G","xmx":"1G"},"constructor":{"xms":"4G","xmx":"4G"},"admin-console":{"xms":"4G","xmx":"4G"}}'
   ```
   ```sh
   bash <(curl -fsSL https://download.elastic.co/cloud/elastic-cloud-enterprise.sh) install --coordinator-host HOST_IP --roles-token 'MY_TOKEN' --roles "director,coordinator,proxy,allocator" --availability-zone MY_ZONE-3 --memory-settings '{"runner":{"xms":"1G","xmx":"1G"},"allocator":{"xms":"4G","xmx":"4G"},"zookeeper":{"xms":"4G","xmx":"4G"},"director":{"xms":"1G","xmx":"1G"},"constructor":{"xms":"4G","xmx":"4G"},"admin-console":{"xms":"4G","xmx":"4G"}}'
   ```
4. [Change the deployment configuration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/working-with-deployments) for the `admin-console-elasticsearch`, `logging-and-metrics`, and `security` clusters to use three availability zones and resize the nodes to use at least 4 GB of RAM. This change makes sure that the clusters used by the administration console are highly available and provisioned sufficiently.
5. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui) to provision your deployment.

If necessary, you can scale and deploy a [medium installation](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/deploy-medium-installation).
Once the installation is complete, you can continue with [Post-installation steps](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/post-installation-steps).