﻿---
title: Customize your deployment components
description: In ECE, you can customize your deployment at any time by selecting Edit from the deployment page. This allows you to fine-tune its capacity and architecture,...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/customize-deployment
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Customize your deployment components
In ECE, you can customize your deployment at any time by selecting **Edit** from the deployment page. This allows you to fine-tune its capacity and architecture, adjust configuration settings, availability zones, and enable or disable [data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers).
<note>
  The configurable components and allowed values available on the Edit page depend on the [deployment template](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/deployment-templates) and [instance configurations](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-configuring-ece-instance-configurations-default) associated with the deployment.
</note>

To customize your deployment:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. On the **Deployments** page, select your deployment.
   Narrow the list by name, ID, or choose from several other [filters](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/search-filter-deployments). To further define the list, use a combination of filters.
3. From your deployment menu, go to the **Edit** page.
4. Let the user interface guide you through the cluster configuration for your cluster. Refer to [Customize your deployment components > Editing deployment](#ece-edit-deployment) for more details.
   <tip>
   When updating an existing deployment, you can make multiple changes to your Elasticsearch cluster with a single configuration update.
   </tip>
5. Select a [configuration strategy](#configuration-strategies) and save your changes. The orchestrator will prepare and execute a plan to apply the requested changes.

Review the changes to your configuration on the **Activity** page, with a tab for Elasticsearch and one for Kibana.

## Editing deployment

In the deployment edit page, you can configure the following settings and features:
- Enable [autoscaling](https://www.elastic.co/docs/deploy-manage/autoscaling/autoscaling-in-ece-and-ech) so that the available resources adjust automatically as demands on the deployment change.
- If you don’t want to autoscale your deployment, you can manually increase or decrease capacity of each [data tier](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers) and component. For example, you might add warm or cold tier nodes for time series data that is accessed infrequently, or expand Kibana capacity to handle higher workloads.
  - From the **Size per zone** drop-down menu, select what best fits your requirements.
  ![Customize hot data and content tier nodes](https://www.elastic.co/docs/deploy-manage/images/cloud-enterprise-ec-customize-deployment2.png)
  Based on the size you select for a tier, ECE automatically calculates the required number of nodes. Before adding additional nodes, the system scales up existing nodes to the maximum size allowed by their instance configuration, as defined in the deployment template. The maximum size for an Elasticsearch instance using the default templates typically ranges between 58GB and 64GB RAM.
  The **Architecture** summary displays the total number of nodes per zone, where each circle color represents a different node type:
  ![Number of nodes per deployment size](https://www.elastic.co/docs/deploy-manage/images/cloud-enterprise-ec-number-of-nodes.png)
- Adjust the number of **Availability zones** for each component to enhance [fault tolerance](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-ha) in your deployment.
- Enable additional components, such as [Machine Learning](https://www.elastic.co/docs/explore-analyze/machine-learning) nodes or an [Integrations server](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/manage-integrations-server).
- Select **Manage user settings and extensions** at Elasticsearch level, or **Edit user settings** for other components, to customize the YML configuration settings and plugin extensions. For more details, refer to [Edit stack user settings](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/edit-stack-settings) and [Add plugins and extensions in Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/add-plugins).
- Select the **Advanced edit** link at the bottom of the page to access the [Advanced cluster configuration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/advanced-cluster-configuration) view.
  <warning>
  You can break things when using the advanced cluster configuration editor. Use this functionality only if you know what you are doing or if you are being directed by someone from Elastic.
  </warning>


## Configuration strategies

When you select **Save changes** on the **Edit deployment** page, the orchestrator initiates a plan to apply the new configuration to your deployment. You can control how these changes are applied to minimize disruption and ensure a smooth transition.
- **Autodetect strategy** (recommended): Let ECE determine the strategy depending on the type changes to apply.
- **Rolling change per node**: One instance at a time. This strategy performs inline, rolling configuration changes that mutate existing containers. Recommended for most configuration changes. If the required resources are unavailable on the ECE nodes handling the existing instances, it falls back to grow and shrink.
- **Grow and shrink**: The orchestrator creates new instances with the new configuration, then migrates the data, and eventually deletes the original ones. This strategy is automatically selected when adding or removing master-eligible instances.
- **Rolling grow and shrink**: Similar to grow and shrink, but creating one instance at a time. This strategy can take a lot longer than grow and shrink.

The `Extended maintenance` optional flag will make ECE to [stop routing requests](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-routing-requests) to all instances during the plan execution. The cluster will be unavailable for external connections while the configuration changes are in progress.
<note>
  If you enable the **Extended maintenance** optional flag, ECE will [stop routing requests](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-routing-requests) to all instances during the plan execution, making the cluster unavailable for external connections while configuration changes are in progress.This option introduces downtime and is rarely needed. Use it only when you need to block all traffic to the cluster during the update.
</note>

When executing plans, always review the reported configuration changes and track progress on the **Activity** page of the deployment, which includes separate tabs for Elasticsearch, Kibana, and other Elastic Stack components.