﻿---
title: Create a deployment
description: An ECE deployment is a fully managed Elastic Stack environment running on Elastic Cloud Enterprise. It includes Elasticsearch, Kibana, and optional features...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/create-deployment
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Create a deployment
An ECE deployment is a fully managed Elastic Stack environment running on Elastic Cloud Enterprise. It includes Elasticsearch, Kibana, and optional features like Machine Learning or an Integrations (Fleet & APM) Server.
Each deployment is based on a [deployment template](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/deployment-templates), which defines its resources, default topology, scaling policies, and available features. Deployments can be customized based on workload requirements, snapshot settings, and security configurations.
To create a deployment in ECE:
1. From the Cloud UI **Deployments** view, select **Create deployment**.
   You can quickly create a deployment by setting the basic parameters shown in the UI. If you need more control, select **Advanced settings** to configure additional options, as detailed below.
   ![Create a deployment](https://www.elastic.co/docs/deploy-manage/images/cloud-enterprise-ece-create-deployment.png)
2. Set a name for your deployment.
3. Select a deployment template.
   For a description of the available system templates, refer to [Deployment templates](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/deployment-templates).
   If the system templates do not meet your requirements, you can [modify them](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-configuring-ece-configure-system-templates) or [create your own custom templates](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-configuring-ece-create-templates).
4. Choose your Elastic Stack version. To manage available versions at platform level, refer to [Manage Elastic Stack versions](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/manage-elastic-stack-versions).
5. Optionally, [use snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-enterprise) to back up your data, or [restore data from another deployment](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/ece-restore-across-clusters).
   <tip>
   Restoring a snapshot can help with major version upgrades by creating a separate, non-production deployment where you can test, for example. Or, make life easier for your developers by providing them with a development environment that is populated with real data.
   </tip>
6. Select **Advanced settings** if you want to configure [autoscaling](https://www.elastic.co/docs/deploy-manage/autoscaling/autoscaling-in-ece-and-ech), adjust resources, [select plugins](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/add-plugins), or customize [data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers). Refer to [Customize your deployment](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/customize-deployment) for more details on the available options.
7. Select **Create deployment**. It takes a few minutes before your deployment gets created.
   While you're waiting, you will be prompted to save the admin credentials for your deployment, which grant superuser access to Elasticsearch. Write down the password for the `elastic` user and keep it somewhere safe. These credentials also help you [add data using Kibana](https://www.elastic.co/docs/manage-data/ingest). If you need to refresh these credentials, you can [reset the password](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/manage-elastic-user-cloud) at any time.
8. Once the deployment is ready, select **Continue** to open the deployment’s main page.

After a deployment is spun up, you can scale the size and add other features; however, the instance configuration and computing ratios cannot be changed. If you need to change an existing deployment to another template, we recommend [migrating your data](https://www.elastic.co/docs/manage-data/migrate).

## Next steps

That’s it! Now that you are up and running, you may want to:
- [Start exploring with Kibana](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/access-kibana), our open-source visualization tool. If you’re not familiar with adding data, yet, Kibana can show you how to index your data into Elasticsearch.
- [Connect your applications to Elasticsearch](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/connect-elasticsearch) to start [ingesting data](https://www.elastic.co/docs/manage-data/ingest)
- Learn how to configure and [manage your deployment](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/working-with-deployments)