﻿---
title: Connect to Elasticsearch
description: This section explains how to connect client applications to an Elasticsearch deployment running on ECE. You can use the endpoint URL available in the...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/connect-elasticsearch
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Connect to Elasticsearch
This section explains how to connect client applications to an Elasticsearch deployment running on ECE. You can use the [endpoint URL](#ece-connect-endpoint) available in the deployment UI, or the [Cloud ID](#ece-cloud-id) for a simplified setup with compatible clients such as Beats and Logstash.
To successfully connect to a deployment, you need both the connection details and valid authentication credentials for an authorized user in the target deployment. For more details on authentication and authorization mechanisms in ECE, refer to [Users and roles](/docs/deploy-manage/users-roles#orchestrator-level).

## Connect using the endpoint URL

To connect to your Elasticsearch cluster, copy the **Elasticsearch endpoint** from the deployment page in the [Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
<important>
  Application endpoints in ECE are generated based on the domain name configured in **Platform > Settings**. To learn how to modify these endpoints, refer to [Change endpoint URLs](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/change-endpoint-urls).
</important>

Once you have the endpoint, use it in your client application. To test connectivity, you can:
- Open the endpoint in your browser and enter authentication details when prompted.
- Modify the following `curl` example to fit your environment by replacing the URL and proxy CA certificate with your own values.
  ```sh
  curl --cacert /path/to/elastic-ece-ca-cert.pem -u elastic https://<CLUSTER_ID.LOCAL_HOST_IP>.ip.es.io:9243
  {
    "name" : "instance-0000000000",
    "cluster_name" : "f76e96da2a7f4d3f8f3ee25d686b879c",
    "cluster_uuid" : "w2SXqdACQCy5AAixXRxeXg",
    "version" : {
      "number" : "8.17.3",
      "build_flavor" : "default",
      "build_type" : "docker",
      "build_hash" : "a091390de485bd4b127884f7e565c0cad59b10d2",
      "build_date" : "2025-02-28T10:07:26.089129809Z",
      "build_snapshot" : false,
      "lucene_version" : "9.12.0",
      "minimum_wire_compatibility_version" : "7.17.0",
      "minimum_index_compatibility_version" : "7.0.0"
    },
    "tagline" : "You Know, for Search"
  }
  ```
  The previous example authenticates to the cluster using the default `elastic` user. For more information on authentication and authorization in Elasticsearch, refer to [Users and roles](https://www.elastic.co/docs/deploy-manage/users-roles).
  <note>
  When connecting to Elasticsearch, you can use one of the following ports:
  - Port 9243 – Secure HTTPS (**recommended**).
  - Port 9200 – Plaintext HTTP (**not recommended**).
  </note>


## Connect using Cloud ID

The Cloud ID reduces the number of steps required to start sending data from [Beats](https://www.elastic.co/docs/reference/beats) or [Logstash](https://www.elastic.co/docs/reference/logstash) to your hosted Elasticsearch cluster on ECE, by assigning a unique ID to your cluster.
<note>
  Connections through Cloud IDs are only supported in Beats and Logstash.
</note>

Cloud IDs are available in every deployment page, as showed below:
![The Cloud ID and `elastic` user information shown when you create a deployment](https://www.elastic.co/docs/deploy-manage/images/cloud-enterprise-ec-ce-cloud-id.png)

Include this ID along with your user credentials (defined in `cloud.auth`) in your Beat or Logstash configuration. ECE will handle the remaining connection details, ensuring secure data transfer to your hosted cluster.

### Before you begin

To use the Cloud ID, you need:
- A deployment with an Elasticsearch cluster to send data to.
- Beats or Logstash, installed locally wherever you want to send data from.
- To configure Beats or Logstash, you need:
  - The unique Cloud ID for your deployment, available from the deployment overview page.
- A user ID and password that has permission to send data to your Elasticsearch cluster.

<important>
  In our examples, we use the `elastic` superuser that every Elasticsearch cluster comes with. The password for the `elastic` user is provided when you create a deployment (and can also be [reset](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-users) if you forget it). On a production system, you should adapt these examples by creating a user that can write to and access only the minimally required indices. For each Beat, review the specific feature and role table, similar to the one in [Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/feature-roles) documentation.
</important>


### Example: Configure Beats with your Cloud ID

The following example shows how you can send operational data from Metricbeat to a new ECE deployment by using the Cloud ID. While this example uses Metricbeat, the same approach applies to other Beats.
<tip>
  For others, you can learn more about [getting started](https://www.elastic.co/docs/reference/beats) with each Beat.
</tip>

To get started with Metricbeat and Elastic Cloud Enterprise:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. [Create a new deployment](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/create-deployment) and copy down the password for the `elastic` user.
3. On the deployment overview page, copy down the Cloud ID.
4. Set up the Beat of your choice, such as [Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-installation-configuration).
5. [Configure the Beat output to send to Elastic Cloud](https://www.elastic.co/docs/reference/beats/metricbeat/configure-cloud-id).
   <note>
   Make sure you replace the values for `cloud.id` and `cloud.auth` with your own information.
   </note>
6. Open Kibana and explore!

Metricbeat creates a data view (formerly *index pattern*) with defined fields, searches, visualizations, and dashboards that you can start exploring in Kibana. Look for information related to system metrics, such as CPU usage, utilization rates for memory and disk, and details for processes.