﻿---
title: Configure ECE
description: Now that you have Elastic Cloud Enterprise up and running, take a look at some of the additional features that you can configure: Assign roles to hosts...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/configure
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Configure ECE
Now that you have Elastic Cloud Enterprise up and running, take a look at some of the additional features that you can configure:

## Common ECE tasks

- [Assign roles to hosts](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/assign-roles-to-hosts) - Make sure new hosts can be used for their intended purpose after you install ECE on them.
- [System deployments configuration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/system-deployments-configuration) - Best practices for ECE system deployments to ensure a highly available and resilient setup.
- [Configure deployment templates](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/configure-deployment-templates) – Define the resources, topology, hardware, and configurations that will be applied to your deployments.
- [Manage Elastic Stack versions](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/manage-elastic-stack-versions) - Upload or remove Elastic Stack packs.
- [Change the ECE API URL](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/change-ece-api-url) - Configure the HTTPS URL used to access the ECE API.
- [Change endpoint URLs](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/change-endpoint-urls) - Configure the URLs to access Elasticsearch and Kibana deployments to match your [domain name](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-wildcard-dns) and [proxy certificate](https://www.elastic.co/docs/deploy-manage/security/secure-your-elastic-cloud-enterprise-installation/manage-security-certificates).
- [Enable custom endpoint aliases](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/enable-custom-endpoint-aliases) - This feature allows to use aliases in the endpoint URLs instead of cluster UUIDs.

Other sections of the documentation describe important ECE features to consider:
- [Configure ECE users and roles](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator) - Manage authentication and authorization at ECE platform level.
- [Manage security certificates](https://www.elastic.co/docs/deploy-manage/security/secure-your-elastic-cloud-enterprise-installation/manage-security-certificates) - Configure Cloud UI and Proxy TLS/SSL certificates.
- [Manage licenses](https://www.elastic.co/docs/deploy-manage/license/manage-your-license-in-ece) - Keep Elastic Cloud Enterprise current with a valid license.
- [Manage snapshot repositories](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-enterprise) - To back up your Elasticsearch clusters automatically, you need to configure a snapshot repository.


## Advanced configuration procedures

- [Configure allocator affinity](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/configure-allocator-affinity) - Determine how ECE distributes your Elastic Stack deployments across allocators.
- [Change allocator disconnect timeout](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/change-allocator-disconnect-timeout) - Configure how long ECE waits before considering allocators to be disconnected.
- [Migrate ECE to Podman hosts](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/migrate-ece-to-podman-hosts) - If you are running a Docker based installation and you need to migrate to Podman.
- [Migrate ECE on Podman hosts to SELinux in enforcing mode](https://www.elastic.co/docs/deploy-manage/security/secure-your-elastic-cloud-enterprise-installation/migrate-ece-on-podman-hosts-to-selinux-enforce) - Migrate ECE to SELinux in `enforcing` mode using Podman.


## Maintenance activities

Refer to [ECE maintenance](https://www.elastic.co/docs/deploy-manage/maintenance/ece) for important maintenance activities, including adding capacity, applying OS patches, and addressing host failures.
- [Scale out your installation](https://www.elastic.co/docs/deploy-manage/maintenance/ece/scale-out-installation) - Need to add more capacity? Here’s how.
- [Enable maintenance mode](https://www.elastic.co/docs/deploy-manage/maintenance/ece/enable-maintenance-mode) - Perform administrative actions on allocators safely by putting them into maintenance mode first.
- [Move nodes from allocators](https://www.elastic.co/docs/deploy-manage/maintenance/ece/move-nodes-instances-from-allocators) - Moves all Elasticsearch clusters and Kibana instances to another allocator, so that the allocator is no longer used for handling user requests.
- [Perform host maintenance](https://www.elastic.co/docs/deploy-manage/maintenance/ece/perform-ece-hosts-maintenance) - Apply operating system patches and other maintenance to hosts safely without removing them from your ECE installation.
- [Delete hosts](https://www.elastic.co/docs/deploy-manage/maintenance/ece/delete-ece-hosts) - Remove a host from your ECE installation, either because it is no longer needed or because it is faulty.