﻿---
title: Configure your deployment
description: You can modify your deployment to adjust resources, enable additional features, or optimize performance. To make sure you’re all set for production, consider...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/configure-deployment
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Configure your deployment
You can modify your deployment to adjust resources, enable additional features, or optimize performance. To make sure you’re all set for production, consider the following actions:
- [Customize your deployment components](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/customize-deployment): Learn how to change your deployment architecture, configure resources, autoscaling, data tiers, and other Elastic Stack components, from the **Edit** deployment view.
- [Edit stack user settings](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/edit-stack-settings): Add, remove, or update Elasticsearch or Kibana YML configuration settings.
- [Resize deployment](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/resize-deployment): Learn how to scale a deployment, including important considerations, and a practical example.
- [Add plugins and extensions in Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/add-plugins): Enable or disable plugins from the list of available extensions in ECE.
- [Add custom bundles and plugins to your deployment](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/add-custom-bundles-plugins): Add custom plugins or external configuration files to your Elasticsearch instances.
- [Configure custom endpoint aliases on Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-regional-deployment-aliases): Configure custom aliases to create predictable and human-readable URLs for your Elastic Stack components, making them easier to share and use.
- [Resource overrides](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/resource-overrides): Temporary extend cluster capacity to improve stability.

Refer to [Manage deployments in Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/working-with-deployments) for additional actions and configurable features for your deployments, such as snapshots, secure settings, and monitoring.

## When to modify your deployment

You might want to change the configuration of your deployment to:
- Add features, such as [machine learning](https://www.elastic.co/docs/explore-analyze/machine-learning) or [APM (application performance monitoring)](https://www.elastic.co/docs/solutions/observability/apm).
- [Increase or decrease capacity](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/resize-deployment) by changing the amount of reserved memory and storage for different parts of your deployment.
- Enable [autoscaling](https://www.elastic.co/docs/deploy-manage/autoscaling/autoscaling-in-ece-and-ech) so that the available resources for deployment components, such as [data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers) and machine learning nodes, adjust automatically as the demands on them change over time.
- Enable [high availability](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-ha), also known as fault tolerance, by adjusting the number of availability zones that parts of your deployment run on.
- [Upgrade](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/upgrade-on-ece) to new versions of Elasticsearch. You can upgrade from one major version to another, such as from 8.18 to 9.0, or from one minor version to another, such as 8.16 to 8.17. You can’t downgrade versions.
- Change what plugins are available on your deployment.
- Update Elasticsearch, Kibana, or other stack application YML configuration settings.


## Applying deployment changes

When you modify a deployment and select **Save changes**, Elastic Cloud Enterprise prepares and executes a **plan** to apply the requested updates and bring the deployment to the desired state. The type of plan depends on the nature of the changes and the selected [configuration strategy](/docs/deploy-manage/deploy/cloud-enterprise/customize-deployment#configuration-strategies). Some plans involve creating new instances and migrating data, while others may require restarting certain components of the deployment.
For single availability zone deployments, there is downtime to portions of your cluster when changes are applied. For [high availability](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-ha) deployments, with the exception of major version upgrades, we these changes can be made without interrupting your deployment. While these changes are being applied, you can continue to search and index.
<note>
  When applying changes, existing data may be migrated to new nodes. For clusters containing large amounts of data, this migration can take some time, especially if your deployment is under a heavy workload. Refer to [Configuration strategies](/docs/deploy-manage/deploy/cloud-enterprise/customize-deployment#configuration-strategies) to learn about the different ways ECE applies changes.
</note>