﻿---
title: Manage deployment templates
description: Deployment templates combine components of the Elastic Stack, such as Elasticsearch nodes and Kibana instances, for different use cases. Compared to a...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/configure-deployment-templates
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Manage deployment templates
Deployment templates combine components of the Elastic Stack, such as Elasticsearch nodes and Kibana instances, for different use cases. Compared to a one-size-fits-all approach to deploying the Elastic Stack, templates provide much greater flexibility and ensure that your deployments have the resources they need to support your use cases. To make the most of deployment templates, you must configure ECE for them.
After installing or upgrading to ECE version 2.0 or later:
1. [Tag your allocators](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-configuring-ece-tag-allocators) to tell ECE what kind of hardware you have available for Elastic Stack deployments.
2. [Edit the default instance configurations](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-configuring-ece-instance-configurations-edit) to match components of the Elastic Stack to your tagged allocators.

If you do not perform these steps, Elastic Cloud Enterprise will behave just as it did in versions before 2.0 and deploy the Elastic Stack wherever there is space on allocators.
Have a use case that isn’t addressed by the ECE default templates? You can also:
- [Create your own instance configurations](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-configuring-ece-instance-configurations-create) to match components of the Elastic Stack to allocators, tailoring what resources they get and what sizes they support.
- [Create your own deployment templates](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-configuring-ece-create-templates) to solve your own use cases better.


## Basic concepts

With ECE version 2.0, a number of new concepts got introduced. Here’s how allocator tags, instance configurations, and deployment templates relate to each other:
<definitions>
  <definition term="Allocator tag">
    Indicates what kind of hardware resources you have available. Used by instance configurations to find suitable allocators.
  </definition>
  <definition term="Instance configuration">
    Matches components of the Elastic Stack to allocators for deployment and tailors how memory and storage resources get sized relative to each other, and what sizes are available. Used as a building block for deployment templates.
  </definition>
  <definition term="Deployment template">
    Solves a specific use case with the Elastic Stack, such as a search or a logging use case. ECE provides some deployment templates out of the box to get you started, or you can create your own.
  </definition>
</definitions>