﻿---
title: Change endpoint URLs
description: Elasticsearch and Kibana endpoint URLs are constructed using the CLUSTER_ID of the component (Elasticsearch or Kibana), and the domain name (CNAME) configured...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/change-endpoint-urls
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Change endpoint URLs
Elasticsearch and Kibana endpoint URLs are constructed using the `CLUSTER_ID` of the component (Elasticsearch or Kibana), and the domain name (`CNAME`) configured in the **Deployment Endpoints** section of the **Platform > Settings** UI.
By default, the deployments `CNAME` is set to `LOCAL_HOST_IP.ip.es.io`, where `LOCAL_HOST_IP` is the IP address of the first installed ECE host. This results in the following default endpoint URLs:
```sh
http://<CLUSTER_ID.LOCAL_HOST_IP>.ip.es.io:9200
https://<CLUSTER_ID.LOCAL_HOST_IP>.ip.es.io:9243
```

<important>
  For security reasons, it is recommended to use **HTTPS (9243)** whenever possible.
</important>

To change endpoints in the Cloud UI:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. From the **Platform** menu, select **Settings**.
3. Specify the deployment domain name (`CNAME`) value for your cluster and Kibana endpoints.
4. Select **Update Deployment endpoints**. The new endpoint becomes effective immediately.

To find your deployment endpoints, select a deployment and review the information on the **Elasticsearch** and **Kibana** pages.
<tip>
  If you install Elastic Cloud Enterprise on AWS, you likely need to modify the cluster endpoint. To learn more, check [Endpoint URLs Inaccessible on AWS](/docs/troubleshoot/deployments/cloud-enterprise/common-issues#ece-aws-private-ip).
</tip>

<tip>
  If you have an App Search instance, after specifying a new deployment domain name value you need to reapply the App Search [cluster configuration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/advanced-cluster-configuration), either with or without any changes.
</tip>

<note>
  The built-in Proxy Certificate only validates against the default endpoint format described on this page. Once you change it, it is necessary to upload a new Proxy Certificate as described in [Manage security certificates](https://www.elastic.co/docs/deploy-manage/security/secure-your-elastic-cloud-enterprise-installation/manage-security-certificates). For test only, clients can be configured with hostname verification disabled until the new certificate is uploaded.
</note>

<note>
  If you do not use wildcard certificates, you must configure SAN entries for each component of the deployment (for example, Elasticsearch or Kibana) and repeat this process for every deployment. Review [Wildcard DNS record and certificates](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-wildcard-dns) for more guidance.
</note>