﻿---
title: Assign roles to hosts
description: Assigning roles might be required after you install Elastic Cloud Enterprise on hosts to make sure the new hosts can be used for their intended purpose...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/assign-roles-to-hosts
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Assign roles to hosts
Assigning roles might be required after you [install Elastic Cloud Enterprise on hosts](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/install) to make sure the new hosts can be used for their intended purpose and to remove roles from the initial host to implement a recommended ECE installation. Similarly, if you need more processing capacity for Elasticsearch nodes in your deployment, change the role of a new runner to `allocator` to add its capacity to your installation.
These steps describe how to assign roles from the Cloud UI. For automation purposes, assigning roles with a [token you generate](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/generate-roles-tokens) is preferred.
Each Elastic Cloud Enterprise runner can take on several roles:
<definitions>
  <definition term="allocator">
    Allocates the available computing resources to Elasticsearch nodes or Kibana instances. In larger installations, a majority of the machines will be allocators.
  </definition>
  <definition term="coordinator">
    Serves as a distributed coordination system and resource scheduler.
  </definition>
  <definition term="proxy">
    Manages communication between a user and an Elasticsearch or Kibana instance.
  </definition>
  <definition term="director">
    Manages the ZooKeeper datastore. This role is typically shared with the coordinator role. In production deployments it can be separated from a coordinator.
  </definition>
</definitions>

<important>
  Once the `director` role is assigned to a runner, the Zookeeper service starts on that host. The Zookeeper service continues even after the  director role is removed from the runner. Therefore, if you remove the `director` role from any host that has ever had it, we highly recommend also [deleting the runner](https://www.elastic.co/docs/deploy-manage/maintenance/ece/delete-ece-hosts) and re-installing it.
</important>

Each role is associated with a set of Docker containers that provide the specific functionality.
There are some additional roles shown in the Cloud UI, such as the [beats-runner](/docs/reference/glossary#glossary-beats-runner) and [services-forwarder](/docs/reference/glossary#glossary-services-forwarder) roles, that are required by Elastic Cloud Enterprise and that you cannot modify.
To assign roles to hosts:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. From the **Platform** menu, select **Hosts**.
   The roles for each host are shown.
   Narrow the list by name, ID, or choose from several other filters. To further define the list, use a combination of filters.
3. To update the roles, select the host IP address and then choose **Manage roles** from the **Manage host** menu.
4. Select the role assignments for the host and choose **Update roles**.

Elastic Cloud Enterprise automatically starts managing the node in its new role and makes it available for use.