﻿---
title: Air-gapped install
description: Installing ECE on hosts without internet access is commonly referred to as an offline or air-gapped installation. ECE supports two air-gapped installation...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/air-gapped-install
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Air-gapped install
Installing ECE on hosts without internet access is commonly referred to as an *offline* or *air-gapped* installation. ECE supports two air-gapped installation methods, depending on whether a private Docker registry is available. In both cases, you must download multiple Docker images and the installation script from Elastic, and load them onto your hosts or private registry.
<note>
  The versioning of Elasticsearch and Kibana is synchronized and versions where the major, minor, and patch levels match can be used together. Differences in build versions indicated by a dash do not affect compatibility.
</note>

Before you start, you must:
- Follow the same prerequisites described in [Install Elastic Cloud Enterprise > Prerequisites](/docs/deploy-manage/deploy/cloud-enterprise/install#ece-install-prerequisites). This includes [Identify the deployment scenario](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/identify-deployment-scenario) and [Prepare your environment](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/prepare-environment) steps.
- [Configure your operating system](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/configure-operating-system) in all ECE hosts.
- Be part of the `docker` group to run the installation script. You should not install Elastic Cloud Enterprise as the `root` user.
- Set up and run a local copy of the Elastic Package Repository, otherwise your deployments with APM server and Elastic agent won’t work. Refer to the [Running EPR in air-gapped environments](/docs/reference/fleet/air-gapped#air-gapped-diy-epr) documentation.

When you are ready to install ECE, you can proceed:
- [With your private Docker registry](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-install-offline-with-registry)
- [Without a private Docker registry](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-install-offline-no-registry)

After installing ECE in your hosts, you can continue with [Post-installation steps](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/post-installation-steps).
<note>
  Deployment End-of-life (EOL) information relies on the connection to [[https://www.elastic.co/support/eol.json](https://www.elastic.co/support/eol.json)](https://www.elastic.co/support/eol.json). If EOL information is updated, Elastic may require you to reconnect to [[https://www.elastic.co/support/eol.json](https://www.elastic.co/support/eol.json)](https://www.elastic.co/support/eol.json) over the internet to get this information reflected.
</note>