﻿---
title: Access Kibana on Elastic Cloud Enterprise
description: Kibana is an open source analytics and visualization platform designed to search, view, and interact with data stored in Elasticsearch indices. To access...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/access-kibana
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Access Kibana on Elastic Cloud Enterprise
Kibana is an open source analytics and visualization platform designed to search, view, and interact with data stored in Elasticsearch indices.
<tip>
  Most deployment templates include a Kibana instance, but if it wasn’t part of the initial deployment you can [customize your deployment components](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/customize-deployment) to add Kibana.
</tip>

To access Kibana:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. On the **Deployments** page, select your deployment.
   Narrow the list by name, ID, or choose from several other filters. To further define the list, use a combination of filters.
3. Under **Applications**, select the Kibana **Open** link and wait for Kibana to open.
   <note>
   The URL provided to access Kibana is based on the [endpoint URL](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/change-endpoint-urls) configured in the ECE **Settings** UI. This URL should resolve to your [external load balancer](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-load-balancers), which forwards the traffic to ECE proxies on port `9243`.If your load balancer is configured to accept traffic on both ports `9243` and `443`, you can use either port when connecting to Kibana. However, [built-in SSO](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator/configure-sso-for-deployments) will only work with the URL configured in ECE **Settings** UI.
   </note>
4. Log into Kibana. Single sign-on (SSO) is enabled between your Elastic Cloud Enterprise account and the Kibana instance. If you’re logged in already, then Kibana opens without requiring you to log in again. However, if your token has expired, choose from one of these methods to log in:
   - Select **Login with Cloud**. You’ll need to log in with an [ECE account](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator/manage-users-roles) credentials and then you’ll be redirected to Kibana.
- Log in with the `elastic` superuser. The password was provided when you created your cluster and [can be reset](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-users).
- Log in with [any users you created in Kibana already](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/user-roles).
   <tip>
   On AWS and not able to access Kibana? [Check if you need to update your endpoint URL first](/docs/troubleshoot/deployments/cloud-enterprise/common-issues#ece-aws-private-ip).
   </tip>

In production systems, you might need to control what Elasticsearch data users can access through Kibana, so you need create credentials that can be used to access the necessary Elasticsearch resources. This means granting read access to the necessary indexes, as well as access to update the `.kibana` index. Refer to [Cluster or deployment users](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth) for more information.