﻿---
title: Elastic Cloud Enterprise
description: Elastic Cloud Enterprise (ECE) is an Elastic self-managed solution for deploying, orchestrating, and managing Elasticsearch clusters at scale. It provides...
url: https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Elastic Cloud Enterprise
Elastic Cloud Enterprise (ECE) is an Elastic self-managed solution for deploying, orchestrating, and managing Elasticsearch clusters at scale. It provides a centralized platform that allows organizations to run Elasticsearch, Kibana, and other Elastic Stack components across multiple machines.
ECE evolves from the [Elastic Cloud Hosted](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud) offering into a standalone product. You can deploy ECE on public or private clouds, virtual machines, or your own premises.
With Elastic Cloud Enterprise, you can:
- Host your regulated or sensitive data on your internal network.
- Reuse your existing investment in on-premise infrastructure and reduce total cost.
- Maximize the hardware utilization for the various clusters.
- Centralize the management of multiple Elastic deployments across teams or geographies.

Refer to [Service-oriented architecture](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-architecture) for details about the ECE platform architecture and the technologies used.
<admonition title="Use cloud services in your ECE environment with Cloud Connect">
  With [Cloud Connect](https://www.elastic.co/docs/deploy-manage/cloud-connect), you can use Elastic-managed cloud services in your ECE environment without having to install and manage their infrastructure yourself. In this way, you can get faster access to new features without adding to your operational overhead.
</admonition>


## ECE features

- **Automated scaling & orchestration**: Handles cluster provisioning, scaling, and upgrades automatically.
- **High availability & resilience**: Ensures uptime through multiple Availability Zones, data replication, and automated restore and snapshot.
- **Centralized monitoring & logging**: Provides insights into cluster performance, resource usage, and logs.
- **Single Sign-On (SSO) & role-based access control (RBAC)**: Allows organizations to manage access and security policies.
- **API & UI management**: Offers a web interface and API to create and manage clusters easily.
- **Air-gapped installations**: Support for off-line installations.
- **Microservices architecture**: All services are containerized through Docker.

Check the [glossary](https://www.elastic.co/docs/reference/glossary) to get familiar with the terminology for ECE as well as other Elastic products and solutions.

## Section overview

This section focuses on deploying the ECE platform, as well as orchestrating and configuring Elasticsearch clusters, referred to as deployments.
In ECE, a deployment is a managed Elastic Stack environment that provides users with an Elasticsearch cluster along with supporting components such as Kibana and other optional services like APM and Fleet.
The section covers the following tasks:
- [Deploy an ECE orchestrator](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/deploy-an-orchestrator)
  - [Prepare the environment](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/prepare-environment)
- [Install ECE](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/install)
- [Air gapped installations](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/air-gapped-install)
- [Configure ECE](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/configure)
- [Work with deployments](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/working-with-deployments)
  - Use [Deployment templates](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/deployment-templates) to [Create a deployment](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/create-deployment)
- [Customize your deployment components](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/customize-deployment)
- [Connect your applications to Elasticsearch](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/connect-elasticsearch)
- Learn about [Tools and APIs for Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/tools-apis) that you can use with ECE

Other sections of the documentation provide guidance on additional important tasks related to ECE:
- Platform security and management:
  - [Secure your ECE installation](https://www.elastic.co/docs/deploy-manage/security/secure-your-elastic-cloud-enterprise-installation)
- [Users and roles](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator)
- [ECE platform maintenance operations](https://www.elastic.co/docs/deploy-manage/maintenance/ece)
- [Manage licenses](https://www.elastic.co/docs/deploy-manage/license/manage-your-license-in-ece)
- Deployments security and management:
  - [Secure your deployments](https://www.elastic.co/docs/deploy-manage/security/secure-your-cluster-deployment)
- [Manage snapshot repositories](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore)

To learn about other deployment options, refer to [Deploy](https://www.elastic.co/docs/deploy-manage/deploy).

## Supported versions

Refer to the [Elastic Support Matrix](https://www.elastic.co/support/matrix#elastic-cloud-enterprise) for more information about supported Operating Systems, Docker, and Podman versions.