﻿---
title: Update billing and operational contacts
description: If different persons from your organization are involved in billing and operations, you can specify their relevant contact details. These additional contacts...
url: https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/update-billing-operational-contacts
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# Update billing and operational contacts
If different persons from your organization are involved in billing and operations, you can specify their relevant contact details. These additional contacts only receive billing or operational emails.
By default, these notifications are sent to all users within an Elastic Cloud organization. If you specify billing and operational email contacts, then only these contacts and the organization owner will receive billing and operational emails.
<note>
  Operational contacts can only receive operational notifications, such as out-of-memory alerts. Operational and billing contacts can’t log in to Elastic Cloud. To log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body),   you must log in as the [organization owner](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles), or be [a member](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization) of the organization.
</note>

To update billing and operational contacts, or set an email address for monitoring alerts:
1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. From a deployment or project on the home page, select **Manage**.
3. From the lower navigation menu, select **Organization**.
4. On the **Contacts** page, specify your new contacts.

You can specify multiple email addresses for each category. They become effective immediately and no further confirmation of the email addresses is required.