﻿---
title: Serverless project billing dimensions
description: Elastic Cloud Serverless billing is based on your usage across these dimensions: Offerings, Add-ons. Specific prices can be found in the Cloud Pricing...
url: https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/serverless-project-billing-dimensions
products:
  - Elastic Cloud Serverless
applies_to:
  - Elastic Cloud Serverless: Generally available
---

# Serverless project billing dimensions
Elastic Cloud Serverless billing is based on your usage across these dimensions:
- [Offerings](#offerings)
- [Add-ons](#add-ons)

Specific prices can be found in the [Cloud Pricing Table](https://cloud.elastic.co/cloud-pricing-table?productType=serverless) or you can create an [Elastic Cloud Serverless Estimate](https://cloud.elastic.co/pricing/serverless).

## Offerings

To learn about billing dimensions for specific offerings, refer to:
- [Elasticsearch Serverless billing dimensions](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/elasticsearch-billing-dimensions)
- [Elastic Observability Serverless billing dimensions](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/elastic-observability-billing-dimensions)
- [Elastic Security billing dimensions](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/security-billing-dimensions)


## Add-ons


### Data out

*Data out* accounts for all of the traffic coming out of a serverless project. This includes search results, as well as monitoring data sent from the project. The same rate applies regardless of the destination of the data, whether to the internet, another region, or a cloud provider account in the same region. Data coming out of the project through AWS PrivateLink, GCP Private Service Connect, or Azure Private Link is also considered data out.

### Support

If your subscription level is Standard, there is no separate charge for Support reflected on your bill. If your subscription level is Gold, Platinum, or Enterprise, a charge is made for Support as a percentage (%) of the ECUs. To find out more about our support levels, go to [[https://www.elastic.co/support](https://www.elastic.co/support)](https://www.elastic.co/support).