﻿---
title: Manage your subscription
description: When you decide to add your credit card and become a paying customer, you can choose a subscription level. Depending on whether you're using Elastic Cloud...
url: https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/manage-subscription
products:
  - Elastic Cloud Hosted
  - Elastic Cloud Serverless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# Manage your subscription
When you decide to add your credit card and become a paying customer, you can choose a subscription level.
Depending on whether you're using Elastic Cloud Hosted deployment or Elastic Cloud Serverless projects, your subscription level might dictate what features you can access or what level of support you receive. On the following pricing pages, you can review additional details about what you get at each subscription level:
- [Elastic Cloud Hosted](https://www.elastic.co/cloud/elasticsearch-service/pricing)
- [Elastic Cloud Serverless](https://www.elastic.co/pricing/serverless-search)

You can find more details about your subscription in the [Billing overview page](https://cloud.elastic.co/billing/overview), in the **Subscription level** section.

## Change your subscription level

If, at any time during your monthly subscription with Elastic Cloud, you decide you need to upgrade to a higher subscription level, you can easily make changes. You can both upgrade to a higher subscription level, or downgrade to a lower one.
To change your subscription level:
1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. From a deployment or project on the home page, select **Manage**.
3. From the lower navigation menu, select **Billing and Subscription**.
4. On the **Overview** page, select **Update subscription**.
5. Choose a new subscription level.
6. Save your changes.

<important>
  - Changing to a higher subscription level takes place immediately. Moving to a lower subscription level takes effect 30 days after you most recently changed to a higher subscription level. In the interim, you pay the current rate. If you haven’t performed a self-service change in the past 30 days, then the change to the lower subscription level is immediate.
  - **Cloud Standard** is not available for customers on the prepaid consumption billing model.
</important>


### Feature usage notifications

<applies-to>
  - Elastic Cloud Hosted: Generally available
</applies-to>

If you try to change your subscription to a lower level, but you are using features that belong either to your current level or to a higher one, you need to make some changes before you can proceed, as described in **Review required feature changes**.
This overview shows you the following details:
- Any features in use that belong to a higher subscription level, grouped by deployment
- Which subscription level you should change to in order to keep those features

You can [change your subscription level](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/manage-subscription) to the recommended level, or stop using the features that belong to a higher level. In the following list, you can find the features we are tracking and the instructions to remove them from your deployments:
<definitions>
  <definition term="Machine learning">
    Edit your deployment to disable [machine learning](https://www.elastic.co/docs/explore-analyze/machine-learning).
  </definition>
  <definition term="Searchable snapshots">
    Edit your deployment index management policies to disable the frozen tier that is using [searchable snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/searchable-snapshots), or set up your cold tier to not mount indices from a searchable snapshot.
  </definition>
  <definition term="JDBC/ODBC clients">
    Make sure that there are no applications that use the SQL [JDBC](https://www.elastic.co/docs/reference/query-languages/sql/sql-jdbc) or [ODBC](https://www.elastic.co/docs/reference/query-languages/sql/sql-odbc) clients.
  </definition>
  <definition term="Field-level or document-level security">
    Remove any user role configurations based on field or document access [through the API](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/controlling-access-at-document-field-level) or the Kibana [Roles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/defining-roles) page.
  </definition>
  <definition term="ES|QL cross-cluster search">
    Discontinue all [ES|QL CCS queries](https://www.elastic.co/docs/reference/query-languages/esql/esql-cross-clusters) or upgrade license tier to Enterprise.
  </definition>
</definitions>

<note>
  After you have made your changes to the deployment, it can take up to one hour to clear the notification banner.
</note>