﻿---
title: Elastic Observability Serverless billing dimensions
description: Elastic Observability Serverless projects provide you with all the capabilities of Elastic Observability to monitor critical applications. Projects are...
url: https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/elastic-observability-billing-dimensions
products:
  - Elastic Cloud Serverless
applies_to:
  - Elastic Cloud Serverless: Generally available
---

# Elastic Observability Serverless billing dimensions
Elastic Observability Serverless projects provide you with all the capabilities of Elastic Observability to monitor critical applications. Projects are provided using a Software as a Service (SaaS) model, and pricing is entirely consumption-based. Elastic Observability Serverless projects are available in the following tiers of carefully selected features to enable common observability operations:
- **Observability Logs Essentials**: Includes everything you need to store and analyze logs at scale.
- **Observability Complete**: Adds full-stack observability capabilities to monitor cloud-native and hybrid environments.

Your monthly bill is based on the capabilities you use. When you use Elastic Observability Serverless, your bill is calculated based on data volume, which has these components:
- **Ingest** — Measured by the number of GB of log/event/info data that you send to your Observability project over the course of a month.
- **Retention** — Measured by the total amount of ingested data stored in your Observability project.

<note>
  Data volumes for ingest and retention are based on the fully enriched normalized data size at the end of the ingest pipeline, before Elasticsearch compression is performed, and will be higher than the volumes traditionally reported by Elasticsearch index size.In addition, these volumes might be larger than those reported by cloud provider proxy logs for data going into Elasticsearch. This allows you to have flexibility in choosing your preferred ingest architecture for enrichment, whether it's through Elastic Agent, Logstash, OpenTelemetry, or collectors — with no impact on the cost.
</note>

Refer to [Serverless billing dimensions](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/serverless-project-billing-dimensions) and the [Elastic Cloud pricing table](https://cloud.elastic.co/cloud-pricing-table?productType=serverless&project=observability) for more details about Elastic Observability Serverless billing dimensions and rates, or you can create a [Serverless estimate](https://cloud.elastic.co/pricing/serverless?s=observability).

## Synthetics

[Synthetic monitoring](https://www.elastic.co/docs/solutions/observability/synthetics) is an optional add-on to Observability Serverless projects that allows you to periodically check the status of your services and applications as a part of the "Observability Complete" feature tier. In addition to the core ingest and retention dimensions, there is a charge to execute synthetic monitors on our testing infrastructure. Browser (journey) based tests are charged per-test-run, and ping (lightweight) tests have an all-you-can-use model per location used.

## Elastic Managed LLMs

[Elastic Managed LLMs](https://www.elastic.co/docs/reference/kibana/connectors-kibana/elastic-managed-llm) enable you to leverage AI-powered search as a service without deploying a model in your serverless project. The models are configured by default to use with the Security AI Assistant, Attack Discovery, and other applicable AI features as a part of the "Observability Complete" feature tier. Using Elastic Managed LLMs will use tokens and incur related token-based add-on billing for your serverless project.