﻿---
title: Elastic Consumption Units
description: All Elastic Cloud usage is metered and billed in Elastic Consumption Units (ECU). An Elastic Consumption Unit is a unit of measure for Elastic Cloud resources...
url: https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/ecu
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# Elastic Consumption Units
All Elastic Cloud usage is metered and billed in Elastic Consumption Units (ECU). An Elastic Consumption Unit is a unit of measure for Elastic Cloud resources (capacity, data transfer, or snapshot storage).
The nominal value of one Elastic Consumption Unit is $1.00. You can use our [Elastic Cloud Hosted pricing calculator](https://cloud.elastic.co/pricing) or our [public pricing table](https://ela.st/esspricelist) to estimate your costs in USD, and then apply the conversion rate of 1 ECU = $1.00 to calculate the ECU equivalent.
Your monthly usage statement is issued in ECU, though it also includes the currency equivalent of your consumption. The **Usage** page in the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body) also shows usage information in ECU.

## Contractual information and quoting

When you sign a prepaid consumption contract, you are purchasing Elastic Consumption Units which can be used to cover your Elastic Cloud usage throughout your contract period.
Elastic Consumption Units measure the value of your usage, as opposed to measuring the cost of the purchase, which may vary based on currency rate and discount.
Refer to our [Billing FAQ](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/billing-faq) for more details about prepaid consumption.

## View available credits

If you have an annual subscription billed using the prepaid consumption model, you can check details of your available credits on the [Billing overview page](https://cloud.elastic.co/billing/overview), in the **Available credits** section.
When you buy ECU to pay for your Elastic Cloud usage, they are contracted through a purchase order consisting of one or more order lines. Each order line has a number of attributes:
<definitions>
  <definition term="Credits">
    The quantity of Elastic Consumption Units purchased through an order line and used to cover your consumption.
  </definition>
  <definition term="Usage">
    Your Elastic Cloud resource consumption quantified in ECU. Resources consumed include capacity (RAM-hours), data transfer (data inter-node and data out), and snapshot storage (storage size or snapshot API calls). These three consumption types are generally known as [billing dimensions](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/cloud-hosted-deployment-billing-dimensions).
  </definition>
  <definition term="Remaining balance">
    The quantity of ECU remaining on an order line. This is calculated as the original amount of credits purchased minus the credits used so far.
  </definition>
  <definition term="Start date">
    The date when the credits belonging to an order line can begin to be used to offset your consumption.
  </definition>
  <definition term="Expiration date">
    The date until which the purchased credits are valid and can be used to offset consumption. After this date, any unused credits are forfeited.
  </definition>
  <definition term="Status">
    An order line can have one of the following statuses:
    - **Active**: this means that the start date is in the past and the expiration date is in the future.
    - **Expired**: The expiration date for the line item is before the current date.
    - **Future**: The start date for the line item is after the current date.
  </definition>
  <definition term="List unit price">
    The list price paid for one ECU, in the transacted currency. This price does not include any discounts.
  </definition>
  <definition term="Discount rate">
    The discount percentage applied to the list unit price of one ECU.
  </definition>
  <definition term="Paid amount">
    The currency cost of the purchased credits. This is calculated as **Credits x List unit price x (100 - Discount rate)/100**.
  </definition>
</definitions>