﻿---
title: Billing FAQ
description: This frequently-asked-questions list answers some of your more common questions about Elastic Cloud billing. General billing questions Is there a way...
url: https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/billing-faq
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Billing FAQ
This frequently-asked-questions list answers some of your more common questions about Elastic Cloud billing.
**General billing questions**
- [Is there a way for me to estimate how much Elastic Cloud will cost?](#faq-cost)
- [Where can I find a detailed view of my consumption?](#faq-consumption)
- [How do I view previous invoices, statements, and billing history?](#faq-history)
- [How can I change who receives invoices, statements, and billing notifications?](#faq-notify)
- [What are the available payment methods on Elastic Cloud?](#faq-payment)
- [Who can I contact for more information?](#faq-contact)
- [Why is my credit card charged?](#faq-charge)
- [When is my credit card charged?](#faq-when)
- [Why is my credit card charged if I canceled my trial?](#faq-whystillcharged)
- [What is the cancellation policy for monthly subscriptions?](#faq-cancelpolicy)
- [Why am I being charged if I don’t use any of my deployments?](#faq-chargednotusing)
- [How can I delete my Elastic Cloud account?](#faq-deleteaccount)
- [Can I get a refund?](#faq-refund)
- [What is included in my paid Elastic Cloud deployment?](#faq-included)
- [Does Cloud Connect require additional payment?](#billing-cc-additional-payment)
- [What are the data transfer and storage charges and how can I control them?](#faq-dts)
- [What taxes will be applied on my invoice?](#faq-taxes)

**Prepaid consumption questions**
- [What purchasing channels can be used for prepaid consumption credits?](#faq-channels)
- [Can I migrate my monthly account to the prepaid consumption model?](#faq-migration)
- [What happens if my credits are depleted mid-year?](#faq-depletion)
- [If I have a multi-year contract and I run out of balance, can I draw against the next year’s credits?](#faq-draw-credits)
- [If my user login is invited to a different organization, what happens to the prepaid credits for the current organization?](#faq-organizations)
- [What kind of subscription level can a customer have on the prepaid consumption model?](#faq-level)
- [Where can I follow the remaining balance and usage?](#faq-usage)
- [How will I know that I am running out of credits?](#faq-notification)
- [How can I pay for on-demand usage?](#faq-on-demand)
- [What happens when a prepaid consumption contract expires and is not renewed?](#faq-lapse)
- [If credits are purchased through multiple orders, which ones get used first?](#faq-credits)
- [What do the prepaid credits cover?](#faq-prepaidcover)


## General billing FAQ

<definitions>
  <definition term="Is there a way for me to estimate how much Elastic Cloud will cost?">
    Yes, there is: If you plan to use Elastic Cloud Hosted deployments, try our [pricing calculator](https://www.elastic.co/cloud/elasticsearch-service/pricing?page=docs&placement=docs-body). You can also use the [Elastic Cloud pricing table](https://ela.st/esspricelist).
  </definition>
  <definition term="Where can I find a detailed view of my consumption?">
    To make it easy to track the ongoing cost of Elastic Cloud, we’ve added line items to the downloadable [invoices](https://cloud.elastic.co/billing/overview?page=docs&placement=docs-body).
    ![Example invoice](https://www.elastic.co/docs/deploy-manage/images/cloud-ec-bill-example-new.png)
    Additionally, on the Elastic Cloud [Usage](https://cloud.elastic.co/billing/usage?page=docs&placement=docs-body) page, the **Month-to-date usage** tile shows accrued costs and can help you to better estimate the next charge amount.
  </definition>
  <definition term="How do I view previous invoices, statements, and billing history?">
    Check the [billing history](https://cloud.elastic.co/billing/history?page=docs&placement=docs-body), where you can view and download invoices for all previous charges.
  </definition>
  <definition term="How can I change who receives invoices, statements, and billing notifications?">
    The account owner can change who receives invoices and billing notifications by changing the [email details](https://cloud.elastic.co/account/contacts?page=docs&placement=docs-body).
  </definition>
  <definition term="What are the available payment methods on Elastic Cloud?">
    For month-to-month payments only credit cards are accepted. We also allow payments by bank transfer for annual subscriptions.
  </definition>
  <definition term="Who can I contact for more information?">
    If you have any further questions about your credit card statement, billing, or invoices, send an email to `ar@elastic.co` or open a [Support case](https://www.elastic.co/docs/troubleshoot) using the *Billing issue* category.
  </definition>
  <definition term="Why is my credit card charged?">
    If you are on a monthly plan, the charge is a recurring fee for using Elastic Cloud. The fee is normally charged at the start of each month, but it can also be charged at other times during the month. If a charge is unsuccessful, we will try to charge your card again at a later date.
  </definition>
  <definition term="When is my credit card charged?">
    You are billed on the first day of each month for usage in the prior month.
  </definition>
  <definition term="Why is my credit card charged if I canceled my trial?">
    If you add a credit card to your Elastic Cloud account at any time during the trial period, the trial is converted to a paid subscription. You then have to pay for any expense incurred by your deployment beginning when the credit card was added. If you delete your deployment at a later date, you will still be invoiced for any usage that occurs between the conversion date and the deployment deletion date.
  </definition>
  <definition term="What is the cancellation policy for monthly subscriptions?">
    There are no cancellation or termination fees for monthly subscriptions. If the service is no longer needed, you can spin down all of your deployments. Usage for that month will be billed at the end of the month in your final bill.
  </definition>
  <definition term="Why am I being charged if I don’t use any of my deployments?">
    Even if you have no activity on your account and you haven’t logged into the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body), your active deployments still incur costs that we need to charge you for. To avoid being charged for active but unused deployments, you can simply delete them. Your account will stay active with no charges, and you can always spin up more capacity when you need it.
  </definition>
  <definition term="How can I delete my Elastic Cloud account?">
    To have your account removed, you can contact support through the Elastic Cloud [Support form](https://cloud.elastic.co/support?page=docs&placement=docs-body) or use one of these [alternative contact methods](https://www.elastic.co/docs/troubleshoot). For details about our data erasure policy, check [Privacy Rights and Choices](https://www.elastic.co/legal/privacy-statement#privacy-rights-and-choices?page=docs&placement=docs-body) in our General Privacy Statement.
  </definition>
  <definition term="Can I get a refund?">
    Charges are non-refundable, but once you delete a deployment we’ll stop charging you for that deployment immediately. You only pay for what you use and you can stop using the service at any time. For any special considerations warranting a potential refund, use the Elastic Cloud Console [Support form](https://cloud.elastic.co/support?page=docs&placement=docs-body) to open a support case and select *Billing issue* as the category. To ensure quick processing, be sure to provide detail about the reasons for the refund request as well as other matters pertaining to the issue. For other ways to open a Support case, check [Contact us](https://www.elastic.co/docs/troubleshoot).
  </definition>
  <definition term="Does Cloud Connect require additional payment?">
    Each [cloud connected service](https://www.elastic.co/docs/deploy-manage/cloud-connect) has its own licensing and payment requirements. For more information, refer to the [Elastic self-managed subscriptions](https://www.elastic.co/subscriptions) page.
    Using AutoOps for self-managed clusters (ECE, ECK, or standalone) on-premise or in private cloud environments through Cloud Connect is included with [self-managed Enterprise licenses](https://www.elastic.co/subscriptions) and self-managed free trials. This does not consume ECU.
  </definition>
  <definition term="What is included in my paid Elastic Cloud Hosted deployment?">
    All subscription tiers for Elastic Cloud Hosted include the following free allowance:
    - Free 1GB RAM Kibana instance
    - Free 1GB RAM Machine Learning node
    - Free 1GB RAM APM / Integrations Server instance
    - A free allowance for [data transfer and snapshot storage costs](#faq-dts)
    Note that if you go above the free tier of Kibana/ML/APM (for example, a 2GB Kibana instance), you will be charged in full for the size of that instance.
  </definition>
  <definition term="What are the data transfer and storage charges and how can I control them?">
    Read about our [usage-based billing dimensions](/docs/deploy-manage/cloud-organization/billing#pricing-model).
  </definition>
  <definition term="What taxes will be applied on my invoice?">
    Customers within the United States, and US territories, will be billed from Elasticsearch Inc., based out of the United States. The US Sales Tax rate will be based on the SaaS tax rates in the local jurisdiction (state/county/city) of the billing address of your subscription.
    Customers outside the United States, will be billed from Elasticsearch BV, based out of the Netherlands. Customers with a billing address in countries with applicable EU VAT will have VAT applied based on their country and status as a business or private customer. Elastic collects VAT Numbers associated with EU VAT to determine your status as a business (B2B) or private / non-business customer (B2C), as this is a key factor to determine Elastic’s liability to charge VAT on your subscription. To update your VAT Number follow the instructions provided in [Add your billing details](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/add-billing-details). Customers located in countries without EU VAT will not be applied VAT on their invoices.
  </definition>
</definitions>


## Prepaid consumption FAQ

The following section applies to annual contracts that are billed on the prepaid consumption billing model.
<definitions>
  <definition term="What purchasing channels can be used for prepaid consumption credits?">
    The prepaid consumption billing model is currently only available for Elastic Direct customers - customers who are purchasing directly from Elastic. This offering may expand to marketplace customers in the future.
  </definition>
  <definition term="Can I migrate my monthly account to the prepaid consumption model?">
    Yes, if you have a monthly Elastic Cloud account, you can [contact us](https://www.elastic.co/cloud/contact) to migrate to prepaid consumption.
  </definition>
  <definition term="What happens if I run out of credits?">
    If your credit balance is entirely consumed while you have an active contract, you can continue to use Elastic Cloud and will receive invoices for the additional on-demand usage.
    - By default, the on-demand usage is billed at the list price in ECU, and invoiced at the currency equivalent.
    - If you have future credit line items that are not active yet, the on-demand usage is billed at the rate of the last active credit line item, using the same payment method. Any discounts that applied to that last active credit line item also apply to the on-demand usage until the next line item becomes active.
  </definition>
  <definition term="If I have a multi-year contract and I run out of balance, can I draw against the next year’s credits?">
    No, this option is currently not available.
  </definition>
  <definition term="If my user login is invited to a different organization, what happens to the prepaid credits for the current organization?">
    Prepaid credits are always assigned to a given organization and NOT to a specific user account. If a user is invited to a different organization, they will not carry the prepaid credits to the new organization.
  </definition>
  <definition term="What kind of subscription level can a customer have on the prepaid consumption model?">
    When the credits are first provisioned, your Cloud account will be set to Enterprise. You can [change your subscription level](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/manage-subscription) at any time. We are offering only Gold, Platinum, and Enterprise support levels for prepaid consumption customers. Standard is not offered for prepaid consumption.
  </definition>
  <definition term="Where can I follow the remaining balance and usage?">
    The current usage and remaining balance can be found in the [Usage](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/monitor-analyze-usage) page. You will also receive monthly usage statements that are published in the [Billing history](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/view-billing-history) page.
  </definition>
  <definition term="How will I know that I am running out of credits?">
    Your account billing contacts and the members of your organization will receive email notifications when your credit balance falls below 33%, 25%, and 16% of credits remaining.
  </definition>
  <definition term="How can I pay for on-demand usage?">
    We only support PO (invoicing) for on-demand usage, for prepaid consumption customers. The issued invoices include tax.
  </definition>
  <definition term="What happens when a prepaid consumption contract expires and is not renewed?">
    Your Elastic Cloud account will automatically change into a monthly account, paid through PO (invoicing). You will continue to incur costs, as we will not delete any of your deployments. You will not benefit from any discount because monthly customers are billed at list prices.  To switch your account to credit card payment, you must first send an email to `CloudBillingOps@elastic.co` to indicate that this is your new preferred payment method. Once your email processed, Elastic will inform you that you can update your credit card information accordingly.
  </definition>
  <definition term="If credits are purchased through multiple orders, which ones get used first?">
    Credits get consumed in the order of expiration (first expired - first used). If two or more order lines have the same expiration date, the one with the highest discount is consumed first. If there are two or more order lines with the same discount, then the one with the lower balance is consumed first.
  </definition>
  <definition term="What do the prepaid credits cover?">
    If you have an annual contract, your prepaid credits are used to cover all usage, including capacity, data transfer, and snapshot storage.
  </definition>
</definitions>