﻿---
title: Add your billing details
description: If you want to use Elastic Cloud beyond the trial period or if you want to use features not included in the trial, then you need to add a credit card...
url: https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/add-billing-details
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# Add your billing details
If you want to use Elastic Cloud beyond the trial period or if you want to use features not included in the trial, then you need to add a credit card to your account. Your credit card information is sent securely to our [billing provider](http://recurly.com/security) and stored with them.
Alternatively, if you want to pay for Elastic Cloud together with other cloud services that you're already using, then you can subscribe to Elastic Cloud through a [marketplace](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/subscribe-from-marketplace).
If you plan to use Elastic Cloud Hosted, then you can estimate how much your use case will cost using our [pricing calculator](https://www.elastic.co/cloud/elasticsearch-service/pricing).
<tip>
  Trials get converted to paid subscriptions and billing starts when you add a credit card. If you want to maximize your trial, make sure to add your credit card near the end of the trial period.
</tip>

To add your billing details:
1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. From a deployment or project on the home page, select **Manage**.
3. From the lower navigation menu, select **Billing and Subscription**.
4. On the **Overview** page, select **Add billing information**.
5. If prompted, complete the multifactor authentication (MFA) required by your bank.

If you want, you can stop new charges by [deleting your project or deployment](https://www.elastic.co/docs/deploy-manage/uninstall/delete-a-cloud-deployment).