﻿---
title: Billing
description: Elastic charges a recurring fee for using our offerings on Elastic Cloud. In this section, you'll learn about the dimensions used to calculate your bill,...
url: https://www.elastic.co/docs/deploy-manage/cloud-organization/billing
products:
  - Elastic Cloud Hosted
  - Elastic Cloud Serverless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# Billing
Elastic charges a recurring fee for using our offerings on Elastic Cloud. In this section, you'll learn about the dimensions used to calculate your bill, how to monitor account usage, how to manage billing, and more.

## Pricing model

Elastic Cloud pricing and billing is based on your usage across a number of dimensions. These dimensions are different for Elastic Cloud Hosted deployments and Elastic Cloud Serverless projects. Each Elastic Cloud Serverless project type also has its own billing dimensions.
- [Cloud Hosted deployment billing dimensions](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/cloud-hosted-deployment-billing-dimensions)
- [Serverless project billing dimensions](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/serverless-project-billing-dimensions)
  - [Elasticsearch Serverless billing dimensions](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/elasticsearch-billing-dimensions)
- [Elastic Observability Serverless billing dimensions](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/elastic-observability-billing-dimensions)
- [Elastic Security billing dimensions](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/security-billing-dimensions)

For more information, you can also refer to our [Elastic Cloud Hosted](https://www.elastic.co/pricing) and [Elastic Cloud Serverless](https://www.elastic.co/pricing/serverless-search) pricing pages.

## Billing models

Depending on your organization's needs, you can use one of several billing models. These models impact who bills you for your usage, and how often you're billed.
[Learn more](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/billing-models).

## Manage your subscription and billing in Elastic Cloud

You can explore and manage billing, as well as your Elastic Cloud subscription, from the **Billing** section of the Elastic Cloud Console.
- [Add your billing details](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/add-billing-details)
- [View your billing history](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/view-billing-history)
- [Manage your notifications](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/manage-billing-notifications)
- [Manage your subscription](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/manage-subscription)
- [Monitor and analyze your account usage](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/monitor-analyze-usage)

You might also want to [update the contacts that receive billing emails](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/update-billing-operational-contacts)
For any other questions that you have about billing, refer to our [billing FAQ](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/billing-faq).

## Stop charges for a deployment or project

To stop charges for an Elastic Cloud deployment or project, you need to [delete it](https://www.elastic.co/docs/deploy-manage/uninstall/delete-a-cloud-deployment).
When a deployment or project is deleted, all data is lost. Billing for usage is by the hour and any outstanding charges for usage before you deleted the deployment or project will still appear on your next bill.