﻿---
title: Manage your Cloud organization
description: When you sign up for Elastic Cloud, you create an organization. This organization is the umbrella for all of your Elastic Cloud resources, users, and...
url: https://www.elastic.co/docs/deploy-manage/cloud-organization
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# Manage your Cloud organization
When you [sign up for Elastic Cloud](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/create-an-organization), you create an organization. This organization is the umbrella for all of your Elastic Cloud resources, users, and account settings. Every organization has a unique identifier.
You can perform the following tasks to manage your Cloud organization:
- [Manage billing](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing)
- Manage user access to your organization:
  - [Add members to your organization](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/manage-users)
- [Assign roles and privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles)
- [Create custom roles](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator) (Serverless only)
- [Configure SAML single sign-on](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/configure-saml-authentication) to your organization
- [Manage API keys](https://www.elastic.co/docs/deploy-manage/api-keys) to use with the [Elastic Cloud](https://www.elastic.co/docs/api/doc/cloud), [Elastic Cloud Billing](https://www.elastic.co/docs/api/doc/cloud-billing/), and [Elastic Cloud Serverless](https://www.elastic.co/docs/api/doc/elastic-cloud-serverless) APIs
- Configure who receives [operational emails](https://www.elastic.co/docs/deploy-manage/cloud-organization/operational-emails) related to your organization
- Track the [status of Elastic Cloud services](https://www.elastic.co/docs/deploy-manage/cloud-organization/service-status).

Several aspects of your organization can also be managed using tools provided by Elastic. For a list of tools, refer to [Elastic Cloud organization tools and APIs](https://www.elastic.co/docs/deploy-manage/cloud-organization/tools-and-apis).
<tip>
  To learn how to manage your Elastic Cloud account as a user, refer to [Manage your Cloud account](https://www.elastic.co/docs/cloud-account).
</tip>