﻿---
title: Serverless project API keys
description: In serverless projects, the following types of API keys exist: Personal API keys, that you can create to allow external services to access your serverless...
url: https://www.elastic.co/docs/deploy-manage/api-keys/serverless-project-api-keys
products:
  - Elastic Cloud Serverless
applies_to:
  - Elastic Cloud Serverless: Generally available
---

# Serverless project API keys
In serverless projects, the following types of API keys exist:
- **Personal** API keys, that you can create to allow external services to access your serverless project on behalf of a user.
- **Managed** API keys, created and managed by Kibana to correctly run background tasks.

You can manage your keys in **Project settings → Management → API keys**:
![API keys UI](https://www.elastic.co/docs/deploy-manage/images/serverless-api-key-management.png)


## Create an API key

In **API keys**, click **Create API key**:
![Create API key UI](https://www.elastic.co/docs/deploy-manage/images/serverless-create-personal-api-key.png)

Once created, you can copy the encoded API key and use it to send requests to the Elasticsearch HTTP API. For example:
```bash
curl "${ES_URL}" \
-H "Authorization: ApiKey ${API_KEY}"
```

<important>
  API keys are intended for programmatic access. Don’t use API keys to authenticate access using a web browser.
</important>


### Control security privileges

When you create or update an API key, use **Control security privileges** to configure access to specific Elasticsearch APIs and resources. Define the permissions using a JSON `role_descriptors` object, where you specify one or more roles and the associated privileges.
For example, the following `role_descriptors` object defines a `books-read-only` role that limits the API key to `read` privileges on the `books` index.
```json
{
  "books-read-only": {
    "cluster": [],
    "indices": [
      {
        "names": ["books"],
        "privileges": ["read"]
      }
    ],
    "applications": [],
    "run_as": [],
    "metadata": {},
    "transient_metadata": {
      "enabled": true
    }
  }
}
```

For the `role_descriptors` object schema, check out the [`/_security/api_key` endpoint](https://www.elastic.co/docs/api/doc/elasticsearch-serverless/operation/operation-security-create-api-key) docs. For supported privileges, check [Security privileges](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-indices).

## Update an API key

In **API keys**, click on the name of the key. You can update only **Restrict privileges** and **Include metadata**.

## View and delete API keys

The **API keys** app lists your API keys, including the name, date created, and status. When API keys expire, the status changes from `Active` to `Expired`.
You can delete API keys individually or in bulk.