﻿---
title: Elastic Cloud API keys
description: Elastic Cloud API keys allow you to use the Elastic Cloud and Elastic Cloud serverless APIs. With a valid Elastic Cloud API key, you can access the API...
url: https://www.elastic.co/docs/deploy-manage/api-keys/elastic-cloud-api-keys
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# Elastic Cloud API keys
Elastic Cloud API keys allow you to use the [Elastic Cloud](https://www.elastic.co/docs/api/doc/cloud/) and [Elastic Cloud serverless](https://www.elastic.co/docs/api/doc/elastic-cloud-serverless/) APIs.
With a valid Elastic Cloud API key, you can access the API from its base URL at `api.elastic-cloud.com`.
Only **Organization owners** can create and manage API keys. An API key is not tied to the user who created it. When creating a key, you assign it specific roles to control its access to organizational resources, including hosted deployments and serverless projects. If a user leaves the organization, the API keys they have created will still function until they expire.
You can have multiple API keys for different purposes, and you can revoke them when you no longer need them.
<note>
  These keys provides access to the API that enables you to manage your deployments. It does not provide access to Elasticsearch. To access Elasticsearch with an API key, create a key [in Kibana](https://www.elastic.co/docs/deploy-manage/api-keys/elasticsearch-api-keys) or [using the Elasticsearch API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-api-key).
</note>


## Create an API key

1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. Go to your avatar in the upper right corner and choose **Organization**.
3. On the **API keys** tab of the **Organization** page, click **Create API key**.
4. On the **Create API key** flyout, you can configure your new key by adding a name, set expiration, or assign [roles](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles).
   By default, API keys expire after three months. You can set the expiration to a different preset value or to a specific date, up to one year. If you need the key to work indefinitely, you can also set its expiration to Never. In this case, the key won’t expire.
   Each organization can have up to 500 active API keys.
   <note>
   When an API key is nearing expiration, Elastic sends an email to the creator of the API key and each of the operational contacts. When you use an API key to authenticate, the API response header `X-Elastic-Api-Key-Expiration` indicates the key’s expiration date. You can log this value to detect API keys that are nearing expiration.Once an API key expires, it will automatically be removed from the API Keys tab.
   </note>
5. Click **Create API key**, copy the generated API key, and store it in a safe place. You can also download the key as a CSV file.

The API key needs to be supplied in the `Authorization` header of a request, in the following format:
```sh
Authorization: ApiKey $EC_API_KEY
```


## Revoke an API key

1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. Go to your avatar in the upper right corner and choose **Organization**.
   The keys currently associated with your organization are listed under the API keys tab of the **Organization** page.
3. Find the key you want to revoke, and click the trash icon under **Actions**.