﻿---
title: Syntax quick reference
description: Elastic documentation uses a custom implementation of MyST Markdown with extended syntax for directives, metadata, and tagging. This page offers quick...
url: https://www.elastic.co/docs/contribute-docs/syntax-quick-reference
---

# Syntax quick reference
Elastic documentation uses a custom implementation of [MyST Markdown](https://mystmd.org/) with extended syntax for directives, metadata, and tagging.
This page offers quick guidance on commonly used syntax elements. Elements are in alphabetical order.
For the full syntax reference, go to [elastic.github.io/docs-builder/syntax/](https://elastic.github.io/docs-builder/syntax/).
<tip>
  Contributing to `elastic.co/guide`? Refer to [Contribute to `elastic.co/guide` (Asciidoc)](https://www.elastic.co/docs/contribute-docs/asciidoc-guide).
</tip>


## Admonitions

Use admonitions to caution users, or to provide helpful tips or extra information.
<dropdown title="Types">
  These examples show the syntax first, followed by the rendered admonition.**Warning**
  ```markdown
      :::{warning}
      Users could permanently lose data or leak sensitive information.
      :::
  ```

  <warning>
    Users could permanently lose data or leak sensitive information.
  </warning>
  **Important**
  ```markdown
      :::{important}
      Less dire than a warning. Users might encounter issues with performance or stability.
      :::
  ```

  <important>
    Less dire than a warning. Users might encounter issues with performance or stability.
  </important>
  **Note**
  ```markdown
      :::{note}
      Supplemental information that provides context or clarification.
      :::
  ```

  <note>
    Supplemental information that provides context or clarification.
  </note>
  **Tip**
  ```markdown
      :::{tip}
      Advice that helps users work more efficiently or make better choices.
      :::
  ```

  <tip>
    Advice that helps users work more efficiently or make better choices.
  </tip>
  **Custom**
  ```markdown
      :::{admonition} Special note
      Custom admonition with custom label.
      :::
  ```

  <admonition title="Special note">
    Custom admonition with custom label.
  </admonition>
</dropdown>

**DOs**
✅ **Do:** Use custom admonitions as needed
**DON'Ts**
❌ **Don't:** Stack admonitions
❌ **Don't:** Overload a page with too many admonitions
[More details: Admonitions →](https://elastic.github.io/docs-builder/syntax/admonitions)


---


## Anchors

A default anchor is automatically created for each [heading](#headings), in the form `#heading-text` (hyphenated, lowercase, special characters and spaces trimmed). To create a custom anchor, add it in square brackets at the end of a heading: `[my-better-anchor]`
<dropdown title="Default anchor">
  ```markdown
  #### Hello world!
  <!-- Auto-generated default anchor: #hello-world -->
  ```
</dropdown>

<dropdown title="Custom anchor">
  ```markdown
  #### Hello world! [get-started]
  ```
</dropdown>

**DOs**
✅ **Do:** Create custom anchors for repeated structural headings like "Example request"
**DON'Ts**
❌ **Don't:** Include punctuation marks in custom anchors
❌ **Don't:** Define custom anchors in text that is not a heading
[More details: Links →](https://elastic.github.io/docs-builder/syntax/links#same-page-links-anchors)


---


## Applies to

Use applies_to metadata to tag content for specific contexts, for example whether a feature is available on certain products, versions, or deployment types.
This metadata enables you to write [cumulative documentation](https://www.elastic.co/docs/contribute-docs/how-to/cumulative-docs), because Elastic no longer publishes separate docs sets for every minor release.
**Example: Section tag**
<dropdown title="Syntax">
  ```markdown
  # Stack-only content
  ```{applies_to}
  stack:
  ```
  ```
</dropdown>

<dropdown title="Output">
  #### Stack-only content

  <applies-to>
    - Elastic Stack: Generally available
  </applies-to>
</dropdown>

For full syntax and more examples, refer to [the `applies_to` documentation](https://elastic.github.io/docs-builder/syntax/applies).
<tip>
  The syntax for `applies_to` metadata differs depending on whether it's added at the [page level](https://elastic.github.io/docs-builder/syntax/applies/#page-level) (in frontmatter), [section level](https://elastic.github.io/docs-builder/syntax/applies/#section-level) (after a heading), or [inline](https://elastic.github.io/docs-builder/syntax/applies/#inline-level).
</tip>

**DOs**
✅ **Do:** Define a set of [page-level tags](https://elastic.github.io/docs-builder/syntax/applies#page-level) in a front matter block
✅ **Do:** Add section-level tags in an `{applies_to}` [directive](https://elastic.github.io/docs-builder/syntax/applies#section-level) after a heading
✅ **Do:** Indicate versions (`major.minor` with an optional `[.patch]`) and release phases like `beta`
**DON'Ts**
❌ **Don't:** Include `applies_to` tags in admonitions
❌ **Don't:** Add `applies_to` tags to general, broadly applicable content


---


## Code blocks

Multi-line blocks for code, commands, configuration, and similar content. Use three backticks ````` on separate lines to start and end the block. For syntax highlighting, add a language identifier after the opening backticks.
<dropdown title="Syntax">
  ```markdown
      ```yaml
      server.host: "0.0.0.0"
      elasticsearch.hosts: ["http://localhost:9200"]
      ```
  ```
</dropdown>

<dropdown title="Output">
  ```yaml
  server.host: "0.0.0.0"
  elasticsearch.hosts: ["http://localhost:9200"]
  ```
</dropdown>

**DOs**
✅ **Do:** Include code blocks within lists or other block elements as needed
✅ **Do:** Add language identifiers like `yaml`, `json`, `bash`
**DON'Ts**
❌ **Don't:** Place code blocks in admonitions
❌ **Don't:** Use inline code formatting (single backticks) for multi-line content
[More details: Code →](https://elastic.github.io/docs-builder/syntax/code)


---


## Code callouts

Inline annotations that highlight or explain specific lines in a code block.

### Explicit callout

To explicitly create a code callout, add a number marker in angle brackets (`<1>`, `<2>`, ...) at the end of a line. Add the corresponding callout text below the code block, in a numbered list that matches the markers.
<dropdown title="Syntax">
  ```markdown
      ```json
      {
        "match": {
          "message": "search text" <1>
        }
      }
      ```
      1. Searches the `message` field for the phrase "search text"
  ```
</dropdown>

<dropdown title="Output">
  ```json
  {
    "match": {
      "message": "search text" 
    }
  }
  ```
</dropdown>


### Magic (comment-based) callout

Add comments with `//` or `#` to magically create callouts.
<dropdown title="Syntax">
  ```markdown
    ```json
    {
      "match": {
        "message": "search text" // Searches the message field
      }
    }
    ```
  ```
</dropdown>

<dropdown title="Output">
  ```json
  {
    "match": {
      "message": "search text"
    }
  }
  ```
</dropdown>

**DOs**
✅ **Do:** Keep callout text short and specific
✅ **Do:** Use only one type of callout per code block (don't mix [explicit](#explicit-callout) and [magic](#magic-callout))
✅ **Do:** Make sure there's a corresponding list item for each explicit callout marker in a code block
**DON'Ts**
❌ **Don't:** Overuse callouts  they can impede readability
[More details: Code callouts→](https://elastic.github.io/docs-builder/syntax/code#code-callouts)


---


## Comments

Use `%` to add single-line comments. Use HTML-style `<!--` and `-->` for multi-line comments.
<dropdown title="Syntax">
  ```markdown
      % This is a comment
      This is regular text

      <!--
      so much depends
      upon
      a multi-line
      comment
      -->
      Regular text after multi-line comment
  ```
</dropdown>

<dropdown title="Output">
  This is regular textRegular text after multi-line comment
</dropdown>

**DOs**
✅ **Do:** Add a space after the `%` in single-line comments
**DON'Ts**
❌ **Don't:** Use `#` or `//` for comments (reserved for [magic callouts](#magic-callout))


---


## Dropdowns

Collapsible blocks for hiding and showing content.
<dropdown title="Syntax">
  ```markdown
      :::{dropdown} Title or label
      Collapsible content
      :::
  ```
</dropdown>

<dropdown title="Output">
  <dropdown title="Title or label">
    Collapsible content
  </dropdown>
</dropdown>

**DOs**
✅ **Do:** Use dropdowns for text, lists, images, code blocks, and tables
✅ **Do:** Add `:open:` to auto-expand a dropdown by default
**DON'Ts**
❌ **Don't:** Use dropdowns for very long paragraphs or entire sections
[More details: Dropdowns →](https://elastic.github.io/docs-builder/syntax/dropdowns)


---


## Headings

Title of a page or a section. To create a heading, add number signs `#` at the beginning of the line (one `#` for each heading level).
<dropdown title="Syntax">
  ```markdown
  # Heading 1
  ## Heading 2
  ### Heading 3
  #### Heading 4
  ```
</dropdown>

<dropdown title="Output">
  ![Heading levels](https://www.elastic.co/docs/contribute-docs/images/headings.png)
</dropdown>

**DOs**
✅ **Do:** Start every page with a Heading 1
✅ **Do:** Use only one Heading 1 per page
✅ **Do:** Define custom anchors for repeated headings
**DON'Ts**
❌ **Don't:** Use headings in tabs or dropdowns
❌ **Don't:** Go deeper than Heading 4
[More details: Headings →](https://elastic.github.io/docs-builder/syntax/headings)


---


## Images

Standard Markdown images: `[alt text]` in square brackets, followed by the image path in parentheses.
<dropdown title="Syntax">
  ```markdown
  ![Bear emerging from hibernation](images/bear.png)
  ```
</dropdown>

<dropdown title="Output">
  ![Bear emerging from hibernation](https://www.elastic.co/docs/contribute-docs/images/bear.png)
</dropdown>

**DOs**
✅ **Do:** Store images in a centralized directory
✅ **Do:** Follow v3 [best practices for screenshots](/docs/contribute-docs/how-to/cumulative-docs/badge-placement#images)
✅ **Do:** Specify `:screenshot:` in an [image directive](https://elastic.github.io/docs-builder/syntax/images#screenshots) to add a border
**DON'Ts**
❌ **Don't:** Use lots of UI screenshots that create a maintenance burden
❌ **Don't:** Include confidential info or PII in an image
❌ **Don't:** Add a drop shadow or torn edge effect
[More details: Images →](https://elastic.github.io/docs-builder/syntax/images)


---


## Inline formatting

Elastic Docs v3 supports standard Markdown inline formatting.
`_emphasis_`  _italics_ 
`**strong**` **bold**  
` `monospace` `  `inline code` (single backticks) 
`~~strikethrough~~`  ~~strikethrough~~ 
`\* escaped`  * escaped character
**DOs**
✅ **Do:** Use `_emphasis_` to introduce a term
✅ **Do:** Use inline `code` in headings and other elements as needed
**DON'Ts**
❌ **Don't:** Overuse `**strong**` or `_emphasis_`  aim for readability


---


## Links

Standard Markdown links to doc pages, sections (anchors), or external content. Prefer absolute paths for links within the doc set.
<dropdown title="Syntax">
  ```markdown
      [link text](/absolute/file.md#anchor)
      [link text](https://external-site.com)
      [link text](other-repo://path/file.md)
      (#same-page-anchor)
  ```
</dropdown>

**DOs**
✅ **Do:** Use inline formatting in link text: `[**bold link**](https://elastic.github.io/docs-builder/syntax/bold-page)`
✅ **Do:** Autogenerate link text from the page or section title: `[](https://elastic.github.io/docs-builder/syntax/use-title#section)`
✅ **Do:** Define a custom [anchor](#anchors) by adding `[anchor-text]` at the end of a heading line
**DON'Ts**
❌ **Don't:** Use unclear, inaccessible link text like "click here" or "this"
❌ **Don't:** Include terminal punctuation in link text
[More details: Links →](https://elastic.github.io/docs-builder/syntax/links)


---


## Lists

Standard Markdown ordered (numbered) and unordered (bulleted) lists. Indent with four spaces to nest paragraphs and other elements under a list item. Unordered lists can start with hyphens `-`, asterisks `*`, or plus signs `+`.
<dropdown title="Syntax">
  ```
      - Unordered item 1
      ····Paragraph within item 1
      - Unordered item 2
  ```

  ```
  1. Ordered item 1
  2. Ordered item 2
  ```
</dropdown>

**DOs** 
✅ **Do:** Add code blocks, images, admonitions, and other content within a list item
✅ **Do:** Nest lists, mixing ordered and unordered as needed
✅ **Do:** Use parallel structure and phrasing in list items
✅ **Do:** Capitalize only the first word of list items (sentence case)
✅ **Do:** Use terminal punctuation consistently and only for complete sentences
**DON'Ts** 
❌ **Don't:** Use lists solely for layout purposes 
❌ **Don't:** Use lists for structured data or comparisons — use tables instead
[More details: Lists →](https://elastic.github.io/docs-builder/syntax/lists)


---


## Navigation title

Optional [front matter](https://elastic.github.io/docs-builder/syntax/frontmatter) element that sets a custom title for docs navigation features: appears in the left nav (table of contents), breadcrumbs, and previous/next links. Compare [headings](#headings) (H1 = page title).
<dropdown title="Syntax">
  Page front matter (yaml):
  ```yaml
    ---
      navigation_title: "Minimalist identifier"
    ---
  ```
  Page title (Markdown H1):
  ```markdown
      # Full descriptive page title with product context
  ```
</dropdown>

<dropdown title="Output">
  ![Rendered nav title](https://www.elastic.co/docs/contribute-docs/images/nav-title.png)
</dropdown>

**DOs**
✅ **Do:** Use active phrasing and shorter forms
✅ **Do:** Make sure the navigation title clearly identifies the page topic
✅ **Do:** Omit product names that appear in the full H1 page title
**DON'Ts**
❌ **Don't:** Duplicate the H1 page title
❌ **Don't:** Use a long navigation title or lots of punctuation
❌ **Don't:** Abbreviate with periods or ellipses
[More details: Title →](https://elastic.github.io/docs-builder/syntax/titles)


---


## Substitutions

Key-value pairs that define reusable variables. They help ensure consistency and enable short forms. To use a substitution (or "sub"), surround the key with curly brackets: `{{variable}}`

### Define a sub

<dropdown title="Syntax">
  In `docset.yml`:
  ```
  subs:
    ccs: "cross-cluster search"
    ech: "Elastic Cloud Hosted"
    kib: "Kibana"
  ```
</dropdown>


### Use a sub

This example uses the sub defined in `docset.yml` above.
<dropdown title="Syntax">
  In `myfile.md`:
  ```
  {{ech}} supports most standard {{kib}} settings.
  ```
</dropdown>

<dropdown title="Output">
  Elastic Cloud Hosted supports most standard Kibana settings.
</dropdown>

**DOs** 
✅ **Do:** Check the global `docset.yml` file for existing product and feature name subs
✅ **Do:** Use substitutions in code blocks by setting `subs=true`  
✅ **Do:** Define new page-specific substitutions as needed
**DON'Ts**
❌ **Don't:** Override a `docset.yml` sub by defining a page-level sub with the same key (causes build errors)
❌ **Don't:** Use substitutions for common words that don't need to be standardized
[More details: Substitutions →](https://elastic.github.io/docs-builder/syntax/substitutions)


---


## Tabs

Block element that displays content in switchable tabs to help users zero in on the right context (such as a deployment or language). [Synced tab groups](https://elastic.github.io/docs-builder/syntax/tabs#tab-groups) are supported.
<dropdown title="Syntax">
  ```markdown
      ::::{tab-set}

      :::{tab-item} Tab 1 title
      Tab 1 content
      :::

      :::{tab-item} Tab 2 title
      Tab 2 content
      :::

      ::::
  ```
</dropdown>

<dropdown title="Output">
  <tab-set>
    <tab-item title="Tab 1 title">
      Tab 1 content
    </tab-item>

    <tab-item title="Tab 2 title">
      Tab 2 content
    </tab-item>
  </tab-set>
</dropdown>

**DOs**
✅ **Do:** Use clear, descriptive tab labels
✅ **Do:** Make sure all tabs have the same type of content and similar goals
✅ **Do:** Keep tab content scannable and self-contained (don't make users switch tabs to follow steps or compare content)
✅ **Do:** Include other block elements in tabs, like [admonitions](#admonitions)
**DON'Ts**
❌ **Don't:** Nest tabs
❌ **Don't:** Split step-by-step procedures across tabs
❌ **Don't:** Use more than 6 tabs (use as few as possible)
❌ **Don't:** Use tabs in [dropdowns](#dropdowns)
[More details: Tabs →](https://elastic.github.io/docs-builder/syntax/tabs)


---


## Tables

Standard table layout for structured data. Automatically scrolls horizontally if needed. The **header** row is optional.
<dropdown title="Syntax">
  ```markdown
      | Header | Header |
      | ------ | ------ |
      | Data   | Info   |
      | Info	 | Data   |
  ```
</dropdown>

<dropdown title="Output">
  | Header | Header |
  |--------|--------|
  | Data   | Info   |
  | Info   | Data   |
</dropdown>

**DOs**
✅ **Do:** Use leading and trailing pipes for clarity
✅ **Do:** Add spaces for readability (they're trimmed)
✅ **Do:** Keep cell content scannable and parallel
✅ **Do:** Use standard Markdown text alignment when necessary (`:-- --: :--:`)
**DON'Ts**
❌ **Don't:** Insert block elements or multiple paragraphs in a table cell
❌ **Don't:** Use a table solely for position or spacing purposes
[More details: Tables →](https://elastic.github.io/docs-builder/syntax/tables)