﻿---
title: Technical writing style guide
description: In this style guide, you can find editorial guidelines for writing clear, consistent documentation that reflects Elastic's friendly tone and our commitment...
url: https://www.elastic.co/docs/contribute-docs/style-guide
---

# Technical writing style guide
In this style guide, you can find editorial guidelines for writing clear, consistent documentation that reflects Elastic's friendly tone and our commitment to editorial quality.

## Quick reference

This quick reference is a summary of the style guide. For more detailed information, refer to the individual sections.

### Voice and tone

A consistent voice builds trust and makes our documentation feel like it comes from one team. Tone adapts to context—friendly for tutorials, direct for troubleshooting—while the voice remains unmistakably Elastic.
- Be human, empathetic, and user-focused.
- Use active voice and present tense.
- Remove words that don't add substance.
- Avoid "please" in instructions.

Refer to [Voice and tone](https://www.elastic.co/docs/contribute-docs/style-guide/voice-tone) for the complete guidelines.

### Accessibility and inclusivity

Accessible content ensures all users can understand our documentation, regardless of how they interact with it. Inclusive language respects and reflects the diversity of our global community.
- Add alt text for all images and media.
- Use meaningful link text (not "click here").
- Avoid directional language (above, below, left, right).
- Use device-agnostic language (select, not click).
- Use gender-neutral pronouns (they/their).

Refer to [Accessibility and inclusivity](https://www.elastic.co/docs/contribute-docs/style-guide/accessibility) for the complete guidelines.

### Grammar and spelling

Correct grammar and consistent spelling reduce ambiguity and help readers focus on the content rather than stumbling over errors. These conventions also support localization and translation efforts.
- Use second-person pronouns (you, your).
- Use Oxford comma.
- Use American English spelling.
- Spell out abbreviations on first use.
- Use sentence-style capitalization.

Refer to [Grammar and spelling](https://www.elastic.co/docs/contribute-docs/style-guide/grammar-spelling) for the complete guidelines.

### Formatting

Consistent formatting helps users scan content quickly and understand relationships between concepts. Visual cues like bold, italic, and monospace distinguish UI elements, terms, and code at a glance.
- **Bold** for UI elements, *italic* for new terms, `monospace` for code.
- Write out numbers 1–9; use numerals for 10+.
- Lists need 2+ items with parallel structure.
- Keep paragraphs under 7 lines.

Refer to [Formatting](https://www.elastic.co/docs/contribute-docs/style-guide/formatting) for the complete guidelines.

### Writing about the UI

Clear UI documentation helps users accomplish tasks efficiently. Focus on what users need to do, not on describing every element they interact with.
- Focus on use cases, not piece-by-piece UI descriptions.
- Keep procedures to 5–9 steps.
- Use arrows for navigation: **Menu → Submenu → Item**.
- Include icon tooltips for accessibility.

Refer to [Writing about the UI](https://www.elastic.co/docs/contribute-docs/style-guide/ui-writing) for the complete guidelines.

### Word choice

The right words make documentation clearer, more inclusive, and easier to localize. Consistent terminology reduces confusion and helps users find what they need.
- Preferred: select, enter, edit, view, create, delete, add, remove.
- Avoid: abort, blacklist/whitelist, click, easy, please, simple.

Refer to [Word choice](https://www.elastic.co/docs/contribute-docs/style-guide/word-choice) for the complete guidelines.

## Automated style checking

The [Vale linter](https://www.elastic.co/docs/contribute-docs/vale-linter) can help you check for style issues while writing documentation. Vale automatically flags common style guide violations, so you can catch and fix issues before publishing.