﻿---
title: Contribute on the web
description: Learn how to make documentation updates directly in your browser without setting up a local development environment. For content hosted on elastic.co/docs,...
url: https://www.elastic.co/docs/contribute-docs/on-the-web
---

# Contribute on the web
Learn how to make documentation updates directly in your browser without setting up a local development environment.
<tip>
  If you're working in [GitHub Codespaces](https://github.com/features/codespaces) or [github.dev](https://github.dev), you can install the [Elastic Docs Utilities extension](https://www.elastic.co/docs/contribute-docs/vscode-extension) to simplify the authoring experience.
</tip>


## Suggesting quick edits

For content hosted on [elastic.co/docs](https://www.elastic.co/docs), most conceptual and narrative content is stored in the [`docs-content`](https://github.com/elastic/docs-content) repository, and most reference content is hosted in the relevant product's repository.
To make quick edits to a single page:
1. Navigate to the documentation page that needs updates.
2. Click the **Edit this page** button. This opens the file in GitHub's editor.
   ![Edit this page button](https://www.elastic.co/docs/contribute-docs/images/edit-this-page.png)
3. Make your changes in the editor.
4. Click **Commit changes**.
5. Write a clear, verb-focused commit message describing your changes.
6. Select **Propose changes**. This takes you to the pull request creation page where you can edit the description if necessary.
7. Select **Create pull request** to submit your changes.

An Elastician will review, merge, and propagate your change to the right places for publication.
For more details on editing files on GitHub, refer to [GitHub's documentation on editing files](https://docs.github.com/en/repositories/working-with-files/managing-files/editing-files).
<warning>
  Some repositories use a [tagged branching strategy](https://elastic.github.io/docs-builder/contribute/branching-strategy/), which means that their docs are published from a branch that is not `main` or `master`. In these cases, documentation changes need to be made to `main` or `master`, and then backported to the relevant branches.For detailed backporting guidance, refer to the example in [Choose the docs branching strategy for a repository](https://elastic.github.io/docs-builder/contribute/branching-strategy/#workflow-2-tagged).To determine the published branches for a repository, find the repository in [`assembler.yml`](https://github.com/elastic/docs-builder/blob/main/config/assembler.yml).
</warning>


## Editing `elastic.co/guide` docs (Asciidoc)

If you need to contribute to [elastic.co/guide](https://elastic.co/guide) pages, refer to [Contribute to `elastic.co/guide` (Asciidoc)](https://www.elastic.co/docs/contribute-docs/asciidoc-guide) to learn about the Asciidoc system.