﻿---
title: Tutorials
description: Guidelines for writing effective tutorials in the Elastic documentation.
url: https://www.elastic.co/docs/contribute-docs/content-types/tutorials
---

# Tutorials
To create tutorials or improve existing tutorials, use the standards and best practices in the guidelines and template.
Use the tutorial guidelines and template to complete the following:
- Create a tutorial by copying and pasting the [template](https://github.com/elastic/docs-content/blob/main/contribute-docs/content-types/_snippets/templates/tutorial-template.md)
- Understand the required structure, scope, and best practices for tutorials
- Evaluate existing tutorials or drafts against the standards

Following the tutorial guidelines and template helps ensure consistency, completeness, and usability across all Elastic Docs.

## What is a tutorial

A tutorial is a comprehensive, hands-on learning experience that guides users through completing a meaningful task from start to finish. You can think of a tutorial as a chain of related [how-to guides](https://www.elastic.co/docs/contribute-docs/content-types/how-tos), with additional explanatory context to help users learn as they work.
Ideally, users can complete a tutorial without needing to jump to other guides. Of course, this is more of an art than a science, and it's important to balance the need for background context with overall readability. If you find yourself needing to write a lot of background context, consider writing multiple, more focused tutorials.
Tutorials include three essential components:
- Clear **learning objectives** that describe what users will be able to accomplish when they have finished the tutorial
- **Prerequisites and setup** needed before starting the tutorial
- A sequence of **instructional steps** that build on each other to accomplish the larger goal

<important>
  Tutorials differ from how-to guides in scope and purpose:
  - **[How-to guides](https://www.elastic.co/docs/contribute-docs/content-types/how-tos)** are focused recipes for a single, discrete task with minimal explanation.
  - **[Tutorials](https://www.elastic.co/docs/contribute-docs/content-types/tutorials)** chain multiple how-to guides together with explanatory context and often detailed code annotations.
  If your content has a broader learning objective beyond completing a single task, use a tutorial.
</important>


## Structure of a tutorial

To help users successfully complete tutorials, all Elastic Docs tutorials follow a consistent structure. A predictable format sets expectations by clearly stating what users will learn, what's required, and what they'll achieve.

### Required elements

Review the required elements that every tutorial must include.
1. A consistent **filename:** Use descriptive patterns like `*-tutorial.md`.
   - For example: `ingest-pipeline-tutorial.md`
2. Appropriate **[frontmatter](https://elastic.github.io/docs-builder/syntax/frontmatter/):**
   - `applies_to:` [Tags](https://elastic.github.io/docs-builder/syntax/applies) for versioning/availability info per the [cumulative docs guidelines](https://www.elastic.co/docs/contribute-docs/how-to/cumulative-docs)
- `description`: A brief summary of what users will learn
- `product`: The relevant Elastic product(s) used in the tutorial

1. A clear **title:** A descriptive title that indicates what users will learn or accomplish
   - For example, "Build an ingest pipeline with processors"
2. An **overview:** Explain what the tutorial teaches, who it's for, and what users will be able to do by the end. Include:
   - A brief description of what users will learn
- The intended audience and their expected skill level
- Learning objectives as a bulleted list
3. A **before you begin** section: List all prerequisites including:
   - Required prior knowledge or skills
- Software, hardware, or access requirements
- Data sets or environments to set up
4. **Instructional steps:** Organize the tutorial into logical sections, each with a descriptive heading. Use numbered steps that begin with imperative verbs.
   <tip>
   Use the [stepper component](https://elastic.github.io/docs-builder/syntax/stepper/) for visual flow, or add subheadings to break complex steps into subsections.
   </tip>
5. **Checkpoints and results:** After significant steps, show users what they should see or what state their system should be in.
6. **[Code annotations](https://elastic.github.io/docs-builder/syntax/code/#code-callouts):** Explain important lines within code blocks to help users understand the code. Annotations can help reduce the need for extra text in the body of the tutorial, keeping the tutorial concise and focused. This makes it easier for a reader to simply run through the steps in a hurry.
7. **Next steps:** Suggest follow-up tutorials, related features to explore, or ways to expand on what they built.
8. **Related pages:** Links to related documentation pages, blogs, or other resources.


### Optional elements

Include the following when they add value:
- **[Screenshots](https://elastic.github.io/docs-builder/syntax/images/#screenshots):** Add visual aids for UI-based steps when they improve clarity. Use screenshots sparingly as they require maintenance.
- **Explanatory callouts:** Use [admonitions](https://elastic.github.io/docs-builder/syntax/admonitions/) to provide extra context, troubleshooting tips, or explanations without interrupting the main flow.
- **Time estimates:** Indicate how long each major section or the overall tutorial takes to complete.
- A **summary:** Recap what users learned and accomplished in the tutorial. Reinforce the key learning objectives.


## Best practices

When you create tutorials, follow these best practices:
- **Focus on learning outcomes:** State what users will be able to do and the value they'll gain. Learning objectives should be clear, achievable, and relevant to real-world tasks.
- **Choose your tutorial approach:** Tutorials can be feature-focused or scenario-driven. Both are valid. Refer to [examples](#examples) for inspiration.
  - **Feature-focused:** Explore features or functionality (useful for deep dives into specific feature sets)
- **Scenario-driven:** Work through a real-world use case (useful for demonstrating end-to-end solutions)
- **Gradually introduce complexity:** Start with simple concepts and use progressive disclosure. Each step should build on the previous steps.
- **Provide context when needed:** Unlike how-to guides, tutorials benefit from explanations of *why* something works or why a particular approach is recommended. That said, it's important to keep the tutorial as concise and focused as possible. Err on the side of brevity.
- **Use realistic examples:** Create examples that mirror real-world scenarios users will meet where possible.
- **Guide the learner:** Assume users are new to the feature or workflow. Provide encouragement and explain what they're accomplishing at key milestones.
- **Include checkpoints:** Add verification steps throughout so users can confirm they're on the right track before continuing.
- **Test your tutorial:** Authors and reviewers should complete the entire tutorial from scratch to identify gaps, errors, or unclear instructions.
  <tip>
  Have someone unfamiliar with the feature try your tutorial. They'll find every gap and unclear step!
  </tip>


## Template

To get started writing a new tutorial, use the [template](https://github.com/elastic/docs-content/blob/main/contribute-docs/content-types/_snippets/templates/tutorial-template.md).

## Examples

Here are some examples of well-structured tutorials in the Elastic documentation:
- [Tutorial: Threat hunting with ES|QL](https://www.elastic.co/docs/solutions/security/esql-for-security/esql-threat-hunting-tutorial): A **scenario-driven** tutorial that teaches ES|QL through a realistic cybersecurity scenario, with extensive code annotations.
- [ES|QL for search tutorial](https://www.elastic.co/docs/reference/query-languages/esql/esql-search-tutorial): A **feature-focused** tutorial that systematically teaches search concepts using ES|QL, from basic text matching to AI-powered semantic search, with subsections breaking down complex topics.